/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.AbstractDataStructure;
import com.sap.engine.lib.util.DeepCloneable;
import com.sap.engine.lib.util.IntHashHolder;
import com.sap.engine.lib.util.IntHashHolderImpl;
import com.sap.engine.lib.util.NotSupportedException;
import com.sap.engine.lib.util.PrimeGenerator;
import com.sap.engine.lib.util.RootDataStructure;
import com.sap.engine.lib.util.base.Pointer;
import com.sap.engine.lib.util.iterators.ArrayEnumeration;
import com.sap.engine.lib.util.iterators.ForwardIterator;
import com.sap.engine.lib.util.iterators.IteratorException;
import com.sap.engine.lib.util.iterators.RootIterator;
import com.sap.engine.lib.util.iterators.SnapShotEnumeration;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class HashMapObjectObject
extends AbstractDataStructure {
    public static final float LOAD_FACTOR = 0.75f;
    public static final int INITIAL_CAPACITY = 13;
    public static final int GROW_STEP = 2;
    protected static final int LAST = -1;
    protected int growStep;
    protected int growSimpl;
    protected float loadFactor;
    protected IntHashHolder hasher;
    protected int simplIndex;
    protected int limit;
    protected int capacity;
    protected transient int nextFree;
    protected transient Object[] keys;
    protected transient Object[] elements;
    protected transient int[] nextPtr;

    public HashMapObjectObject() {
        this(13, 2, 0.75f, new IntHashHolderImpl());
    }

    public HashMapObjectObject(int initialCapacity) {
        this(initialCapacity, 2, 0.75f, new IntHashHolderImpl());
    }

    public HashMapObjectObject(int initialCapacity, int growStep, float loadFactor, IntHashHolder hasher) {
        if ((double)loadFactor > 1.0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Load Factor = " + loadFactor);
        }
        if (growStep <= 1) {
            throw new IllegalArgumentException("Grow step = " + growStep);
        }
        this.growStep = growStep;
        this.growSimpl = growStep == 2 ? 4 : (growStep < 10 ? growStep + 4 : 13);
        this.loadFactor = loadFactor;
        this.hasher = hasher;
        this.simplIndex = 0;
        this.init(initialCapacity);
    }

    public Enumeration keys() {
        return new Enumeration(){
            private int i = 0;
            private int pos;
            private int counter;
            {
                this.pos = HashMapObjectObject.this.nextPtr[this.i];
                this.counter = 0;
            }

            public boolean hasMoreElements() {
                return this.counter < HashMapObjectObject.this.count;
            }

            public Object nextElement() {
                while (this.i < HashMapObjectObject.this.capacity) {
                    if (this.pos != -1) {
                        Object result = HashMapObjectObject.this.keys[this.pos - HashMapObjectObject.this.capacity];
                        this.pos = HashMapObjectObject.this.nextPtr[this.pos];
                        ++this.counter;
                        return result;
                    }
                    this.pos = HashMapObjectObject.this.nextPtr[++this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Object[] getAllKeys() {
        return this.getAllKeys(new Object[this.count]);
    }

    public Object[] getAllKeys(Object[] result) {
        int index = 0;
        if (result.length < this.count) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), this.count);
        }
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                result[index++] = this.keys[pos - this.capacity];
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return result;
    }

    public Enumeration elements() {
        return new Enumeration(){
            private int i = 0;
            private int pos;
            private int counter;
            {
                this.pos = HashMapObjectObject.this.nextPtr[this.i];
                this.counter = 0;
            }

            public boolean hasMoreElements() {
                return this.counter < HashMapObjectObject.this.count;
            }

            public Object nextElement() {
                while (this.i < HashMapObjectObject.this.capacity) {
                    if (this.pos != -1) {
                        Object result = HashMapObjectObject.this.elements[this.pos - HashMapObjectObject.this.capacity];
                        this.pos = HashMapObjectObject.this.nextPtr[this.pos];
                        ++this.counter;
                        return result;
                    }
                    this.pos = HashMapObjectObject.this.nextPtr[++this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Object[] getAllValues() {
        return this.getAllValues(new Object[this.count]);
    }

    public Object[] getAllValues(Object[] result) {
        int index = 0;
        if (result.length < this.count) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), this.count);
        }
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                result[index++] = this.elements[pos - this.capacity];
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return result;
    }

    public boolean contains(Object value) {
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                if (this.elements[pos - this.capacity].equals(value)) {
                    return true;
                }
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public void clear() {
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        int i3 = 0;
        while (i3 < this.elements.length) {
            this.keys[i3] = null;
            this.elements[i3] = null;
            ++i3;
        }
        this.nextFree = this.capacity;
        this.count = 0;
    }

    public Object clone() {
        HashMapObjectObject result = (HashMapObjectObject)super.clone();
        result.keys = new Object[this.keys.length];
        result.elements = new Object[this.elements.length];
        result.nextPtr = new int[this.nextPtr.length];
        System.arraycopy(this.nextPtr, 0, result.nextPtr, 0, this.nextPtr.length);
        System.arraycopy(this.keys, 0, result.keys, 0, this.keys.length);
        System.arraycopy(this.elements, 0, result.elements, 0, this.elements.length);
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HashMapObjectObject)) {
            return false;
        }
        HashMapObjectObject t = (HashMapObjectObject)object;
        if (t.count != this.count) {
            return false;
        }
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                int index = pos - this.capacity;
                Object temp = t.get(this.keys[index]);
                if (temp == null) {
                    return false;
                }
                if (!this.elements[index].equals(temp)) {
                    return false;
                }
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return true;
    }

    public void shrink() {
        this.shrink(0.75f);
    }

    public void shrink(float shrinkFactor) {
        if (shrinkFactor <= 0.0f || (double)shrinkFactor > 1.0) {
            throw new IllegalArgumentException("Shrink Factor = " + shrinkFactor);
        }
        int newCapacity = (int)((float)this.count / (this.loadFactor * shrinkFactor));
        long l = PrimeGenerator.getClosestPrime(newCapacity);
        this.simplIndex = (int)(l >> 32);
        newCapacity = (int)l;
        if (newCapacity < this.capacity) {
            int oldCapacity = this.capacity;
            int[] oldPtr = this.nextPtr;
            Object[] oldKeys = this.keys;
            Object[] oldElements = this.elements;
            this.init(newCapacity);
            int i = 0;
            while (i < oldCapacity) {
                int pos = oldPtr[i];
                while (pos != -1) {
                    int index = pos - oldCapacity;
                    this.putQuick(oldKeys[index], oldElements[index]);
                    pos = oldPtr[pos];
                }
                ++i;
            }
        }
    }

    public Object put(Object key, Object value) {
        int index;
        if (value == null) {
            throw new NullPointerException("Value can not be null.");
        }
        if (this.count == this.limit) {
            this.rehash();
        }
        int pos = this.hasher.hash(key.hashCode()) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            index = (pos = this.nextPtr[pos]) - this.capacity;
            if (!this.keys[index].equals(key)) continue;
            Object temp = this.elements[index];
            this.elements[index] = value;
            return temp;
        }
        index = this.nextFree - this.capacity;
        this.nextPtr[pos] = this.nextFree;
        this.keys[index] = key;
        this.elements[index] = value;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
        return null;
    }

    protected void putQuick(Object key, Object value) {
        int pos = this.hasher.hash(key.hashCode()) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            pos = this.nextPtr[pos];
        }
        int index = this.nextFree - this.capacity;
        this.nextPtr[pos] = this.nextFree;
        this.keys[index] = key;
        this.elements[index] = value;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
    }

    public Object get(Object key) {
        int pos = this.nextPtr[this.hasher.hash(key.hashCode()) % this.capacity];
        while (pos != -1) {
            int index = pos - this.capacity;
            if (this.keys[index].equals(key)) {
                return this.elements[index];
            }
            pos = this.nextPtr[pos];
        }
        return null;
    }

    public Object remove(Object key) {
        int prevPos = this.hasher.hash(key.hashCode()) % this.capacity;
        int pos = this.nextPtr[prevPos];
        while (pos != -1) {
            int index = pos - this.capacity;
            if (this.keys[index].equals(key)) {
                Object result = this.elements[index];
                this.keys[index] = null;
                this.elements[index] = null;
                this.nextPtr[prevPos] = this.nextPtr[pos];
                this.nextPtr[pos] = this.nextFree;
                this.nextFree = pos;
                --this.count;
                return result;
            }
            prevPos = pos;
            pos = this.nextPtr[pos];
        }
        return null;
    }

    protected void init(int initialCapacity) {
        if (this.growStep > 17) {
            this.capacity = (int)PrimeGenerator.getClosestPrime(initialCapacity);
        } else {
            long l = PrimeGenerator.getClosestPrime(initialCapacity, this.simplIndex);
            this.simplIndex = (int)(l >> 32) + this.growSimpl;
            this.capacity = (int)l;
        }
        this.limit = (int)((float)this.capacity * this.loadFactor);
        this.nextPtr = new int[this.capacity + this.limit];
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.keys = new Object[this.limit];
        this.elements = new Object[this.limit];
        this.nextFree = this.capacity;
        this.count = 0;
    }

    protected void rehash() {
        Object[] oldKeys = this.keys;
        Object[] oldElements = this.elements;
        this.init(this.capacity * this.growStep);
        int i = 0;
        while (i < oldKeys.length) {
            this.putQuick(oldKeys[i], oldElements[i]);
            ++i;
        }
    }

    public String toString() {
        int c = 0;
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                int index = pos - this.capacity;
                buf.append(this.keys[index] + "=" + this.elements[index]);
                if (++c < this.count) {
                    buf.append(", ");
                }
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public void setHasher(IntHashHolder hasher) {
        this.hasher = hasher;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                int index = pos - this.capacity;
                stream.writeObject(this.keys[index]);
                stream.writeObject(this.elements[index]);
                pos = this.nextPtr[pos];
            }
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.nextPtr = new int[this.capacity + this.limit];
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.keys = new Object[this.limit];
        this.elements = new Object[this.limit];
        this.nextFree = this.capacity;
        int size = this.count;
        this.count = 0;
        int i3 = 0;
        while (i3 < size) {
            this.putQuick(stream.readObject(), stream.readObject());
            ++i3;
        }
    }

    public RootIterator keysIterator() {
        return new HashMapObjectObjectKeysIterator();
    }

    public RootIterator elementsIterator() {
        return new HashMapObjectObjectElementsIterator();
    }

    public SnapShotEnumeration elementsEnumeration() {
        return new ArrayEnumeration(this.toArray());
    }

    public Object[] toArray() {
        return this.getAllValues();
    }

    public Pointer[] toPointerArray() {
        throw new NotSupportedException("Use toArray() method instead!");
    }

    public Object deepClone() {
        HashMapObjectObject result = (HashMapObjectObject)super.clone();
        result.keys = new Object[this.keys.length];
        result.elements = new Object[this.elements.length];
        result.nextPtr = new int[this.nextPtr.length];
        int i = 0;
        while (i < this.keys.length) {
            result.keys[i] = ((DeepCloneable)this.keys[i]).deepClone();
            result.elements[i] = ((DeepCloneable)this.elements[i]).deepClone();
            ++i;
        }
        System.arraycopy(this.nextPtr, 0, result.nextPtr, 0, this.nextPtr.length);
        return result;
    }

    protected Object iterGet(RootIterator rootIter, boolean keysOrElems) {
        if (keysOrElems) {
            HashMapObjectObjectKeysIterator iter = (HashMapObjectObjectKeysIterator)rootIter;
            if (iter.counter >= iter.end) {
                throw new IteratorException("End of Iterator reached!");
            }
            int tmpI = iter.i;
            int tmpPos = iter.pos;
            while (tmpI < this.capacity) {
                if (tmpPos != -1) {
                    return this.keys[tmpPos - this.capacity];
                }
                tmpPos = this.nextPtr[++tmpI];
            }
            throw new IteratorException("End of Iterator reached!");
        }
        HashMapObjectObjectElementsIterator iter = (HashMapObjectObjectElementsIterator)rootIter;
        if (iter.counter >= iter.end) {
            throw new IteratorException("End of Iterator reached!");
        }
        int tmpI = iter.i;
        int tmpPos = iter.pos;
        while (tmpI < this.capacity) {
            if (tmpPos != -1) {
                return this.elements[tmpPos - this.capacity];
            }
            tmpPos = this.nextPtr[++tmpI];
        }
        throw new IteratorException("End of Iterator reached!");
    }

    /*
     * Unable to fully structure code
     */
    protected Object iterNext(RootIterator rootIter, int offset, boolean keysOrElems) {
        block8: {
            if (!keysOrElems) break block8;
            iter = (HashMapObjectObjectKeysIterator)rootIter;
            if (offset < 0) {
                throw new IteratorException("Invalid argument: " + offset + " < 0");
            }
            newCounter = HashMapObjectObjectKeysIterator.access$000(iter) + offset;
            if (newCounter < HashMapObjectObjectKeysIterator.access$100(iter)) ** GOTO lbl23
            throw new IteratorException("End of Iterator reached!");
            {
                result = this.keys[HashMapObjectObjectKeysIterator.access$300(iter) - this.capacity];
                HashMapObjectObjectKeysIterator.access$802(iter, HashMapObjectObjectKeysIterator.access$300(iter));
                HashMapObjectObjectKeysIterator.access$302(iter, this.nextPtr[HashMapObjectObjectKeysIterator.access$300(iter)]);
                if (HashMapObjectObjectKeysIterator.access$008(iter) == newCounter) {
                    return result;
                }
                do {
                    if (HashMapObjectObjectKeysIterator.access$300(iter) != -1) continue block0;
                    HashMapObjectObjectKeysIterator.access$208(iter);
                    HashMapObjectObjectKeysIterator.access$802(iter, HashMapObjectObjectKeysIterator.access$200(iter));
                    HashMapObjectObjectKeysIterator.access$302(iter, this.nextPtr[HashMapObjectObjectKeysIterator.access$200(iter)]);
lbl23:
                    // 2 sources

                } while (HashMapObjectObjectKeysIterator.access$200(iter) < this.capacity);
            }
            throw new IteratorException("End of Iterator reached!");
        }
        iter = (HashMapObjectObjectElementsIterator)rootIter;
        if (offset < 0) {
            throw new IteratorException("Invalid argument: " + offset + " < 0");
        }
        newCounter = HashMapObjectObjectElementsIterator.access$400(iter) + offset;
        if (newCounter < HashMapObjectObjectElementsIterator.access$500(iter)) ** GOTO lbl47
        throw new IteratorException("End of Iterator reached!");
        {
            result = this.elements[HashMapObjectObjectElementsIterator.access$700(iter) - this.capacity];
            HashMapObjectObjectElementsIterator.access$902(iter, HashMapObjectObjectElementsIterator.access$700(iter));
            HashMapObjectObjectElementsIterator.access$702(iter, this.nextPtr[HashMapObjectObjectElementsIterator.access$700(iter)]);
            if (HashMapObjectObjectElementsIterator.access$408(iter) == newCounter) {
                return result;
            }
            do {
                if (HashMapObjectObjectElementsIterator.access$700(iter) != -1) continue block2;
                HashMapObjectObjectElementsIterator.access$608(iter);
                HashMapObjectObjectElementsIterator.access$902(iter, HashMapObjectObjectElementsIterator.access$600(iter));
                HashMapObjectObjectElementsIterator.access$702(iter, this.nextPtr[HashMapObjectObjectElementsIterator.access$600(iter)]);
lbl47:
                // 2 sources

            } while (HashMapObjectObjectElementsIterator.access$600(iter) < this.capacity);
        }
        throw new IteratorException("End of Iterator reached!");
    }

    /*
     * Unable to fully structure code
     */
    protected Object iterRemove(RootIterator rootIter, boolean keysOrElems) {
        block6: {
            if (!keysOrElems) break block6;
            iter = (HashMapObjectObjectKeysIterator)rootIter;
            if (this.count == 0) {
                throw new IteratorException("Iterator is empty!");
            }
            if (HashMapObjectObjectKeysIterator.access$000(iter) < HashMapObjectObjectKeysIterator.access$100(iter)) ** GOTO lbl27
            throw new IteratorException("End of Iterator reached!");
lbl-1000:
            // 1 sources

            {
                if (HashMapObjectObjectKeysIterator.access$300(iter) != -1) {
                    index = HashMapObjectObjectKeysIterator.access$300(iter) - this.capacity;
                    result = this.keys[index];
                    this.keys[index] = null;
                    this.elements[index] = null;
                    this.nextPtr[HashMapObjectObjectKeysIterator.access$800((HashMapObjectObjectKeysIterator)iter)] = this.nextPtr[HashMapObjectObjectKeysIterator.access$300(iter)];
                    this.nextPtr[HashMapObjectObjectKeysIterator.access$300((HashMapObjectObjectKeysIterator)iter)] = this.nextFree;
                    this.nextFree = HashMapObjectObjectKeysIterator.access$300(iter);
                    HashMapObjectObjectKeysIterator.access$302(iter, this.nextPtr[HashMapObjectObjectKeysIterator.access$800(iter)]);
                    --this.count;
                    HashMapObjectObjectKeysIterator.access$008(iter);
                    return result;
                }
                HashMapObjectObjectKeysIterator.access$208(iter);
                HashMapObjectObjectKeysIterator.access$802(iter, HashMapObjectObjectKeysIterator.access$200(iter));
                HashMapObjectObjectKeysIterator.access$302(iter, this.nextPtr[HashMapObjectObjectKeysIterator.access$200(iter)]);
lbl27:
                // 2 sources

                ** while (HashMapObjectObjectKeysIterator.access$200((HashMapObjectObjectKeysIterator)iter) < this.capacity)
            }
lbl28:
            // 1 sources

            throw new IteratorException("End of Iterator reached!");
        }
        iter = (HashMapObjectObjectElementsIterator)rootIter;
        if (this.count == 0) {
            throw new IteratorException("Iterator is empty!");
        }
        if (HashMapObjectObjectElementsIterator.access$400(iter) < HashMapObjectObjectElementsIterator.access$500(iter)) ** GOTO lbl55
        throw new IteratorException("End of Iterator reached!");
lbl-1000:
        // 1 sources

        {
            if (HashMapObjectObjectElementsIterator.access$700(iter) != -1) {
                index = HashMapObjectObjectElementsIterator.access$700(iter) - this.capacity;
                result = this.elements[index];
                this.keys[index] = null;
                this.elements[index] = null;
                this.nextPtr[HashMapObjectObjectElementsIterator.access$900((HashMapObjectObjectElementsIterator)iter)] = this.nextPtr[HashMapObjectObjectElementsIterator.access$700(iter)];
                this.nextPtr[HashMapObjectObjectElementsIterator.access$700((HashMapObjectObjectElementsIterator)iter)] = this.nextFree;
                this.nextFree = HashMapObjectObjectElementsIterator.access$700(iter);
                HashMapObjectObjectElementsIterator.access$702(iter, this.nextPtr[HashMapObjectObjectElementsIterator.access$900(iter)]);
                --this.count;
                HashMapObjectObjectElementsIterator.access$408(iter);
                return result;
            }
            HashMapObjectObjectElementsIterator.access$608(iter);
            HashMapObjectObjectElementsIterator.access$902(iter, HashMapObjectObjectElementsIterator.access$600(iter));
            HashMapObjectObjectElementsIterator.access$702(iter, this.nextPtr[HashMapObjectObjectElementsIterator.access$600(iter)]);
lbl55:
            // 2 sources

            ** while (HashMapObjectObjectElementsIterator.access$600((HashMapObjectObjectElementsIterator)iter) < this.capacity)
        }
lbl56:
        // 1 sources

        throw new IteratorException("End of Iterator reached!");
    }

    protected Object iterChange(RootIterator rootIter, Object obj) {
        HashMapObjectObjectElementsIterator iter = (HashMapObjectObjectElementsIterator)rootIter;
        if (obj == null) {
            throw new IteratorException("An illegal attempt to change a value to null!");
        }
        if (this.count == 0) {
            throw new IteratorException("Iterator is empty!");
        }
        if (iter.counter >= iter.end) {
            throw new IteratorException("End of Iterator reached!");
        }
        int tmpI = iter.i;
        int tmpPos = iter.pos;
        while (tmpI < this.capacity) {
            if (tmpPos != -1) {
                int index = tmpPos - this.capacity;
                Object result = this.elements[index];
                this.elements[index] = obj;
                return result;
            }
            tmpPos = this.nextPtr[++tmpI];
        }
        throw new IteratorException("End of Iterator reached!");
    }

    protected class HashMapObjectObjectElementsIterator
    implements ForwardIterator {
        private int i;
        private int prevPos;
        private int pos;
        private int start;
        private int end;
        private int counter;

        protected HashMapObjectObjectElementsIterator() {
            this.prevPos = this.i = 0;
            this.pos = HashMapObjectObject.this.nextPtr[this.i];
            this.start = 0;
            this.end = HashMapObjectObject.this.count;
            this.counter = this.start;
        }

        public Object get() {
            return HashMapObjectObject.this.iterGet(this, false);
        }

        public boolean isAtBegin() {
            return this.counter == this.start;
        }

        public boolean isAtEnd() {
            return this.counter == this.end;
        }

        public RootDataStructure getDataStructure() {
            return HashMapObjectObject.this;
        }

        public Object next() {
            return HashMapObjectObject.this.iterNext(this, 0, false);
        }

        public Object next(int n) {
            return HashMapObjectObject.this.iterNext(this, n, false);
        }

        public void setStartFromIterator(RootIterator iterator) {
            HashMapObjectObjectElementsIterator hmooei = (HashMapObjectObjectElementsIterator)iterator;
            if (HashMapObjectObject.this != hmooei.getDataStructure()) {
                throw new IteratorException("An attempt to set start from an Iterator over a different HashMapObjectObject instance!");
            }
            int newCounter = hmooei.counter;
            int newPrevPos = hmooei.prevPos;
            int newPos = hmooei.pos;
            int newI = hmooei.i;
            if (newCounter >= this.end) {
                throw new IteratorException("An attempt to set the start behind the end of the Iterator: " + newCounter + " >= " + this.end);
            }
            this.counter = this.start = newCounter;
            this.prevPos = newPrevPos;
            this.pos = newPos;
            this.i = newI;
        }

        public void setEndFromIterator(RootIterator iterator) {
            HashMapObjectObjectElementsIterator hmooei = (HashMapObjectObjectElementsIterator)iterator;
            if (HashMapObjectObject.this != hmooei.getDataStructure()) {
                throw new IteratorException("An attempt to set end from an Iterator over a different HashMapObjectObject instance!");
            }
            int newCounter = hmooei.counter;
            if (newCounter < this.counter) {
                throw new IteratorException(" end ahead of the current position of the Iterator: " + newCounter + " < " + this.counter);
            }
            this.end = newCounter;
        }

        public Object add(Object obj) {
            throw new IteratorException("Operation is not supported!");
        }

        public Object change(Object obj) {
            return HashMapObjectObject.this.iterChange(this, obj);
        }

        public Object remove() {
            return HashMapObjectObject.this.iterRemove(this, false);
        }

        public Object insert(Object obj) {
            throw new IteratorException("Operation is not supported!");
        }

        public int size() {
            return this.end - this.start;
        }

        public boolean isInsertable() {
            return false;
        }

        public boolean isRemoveable() {
            return true;
        }

        public boolean isChangeable() {
            return true;
        }

        public boolean isAddable() {
            return false;
        }

        static /* synthetic */ int access$902(HashMapObjectObjectElementsIterator x0, int x1) {
            x0.prevPos = x1;
            return x0.prevPos;
        }

        static /* synthetic */ int access$702(HashMapObjectObjectElementsIterator x0, int x1) {
            x0.pos = x1;
            return x0.pos;
        }

        static /* synthetic */ int access$408(HashMapObjectObjectElementsIterator x0) {
            return x0.counter++;
        }

        static /* synthetic */ int access$608(HashMapObjectObjectElementsIterator x0) {
            return x0.i++;
        }

        static /* synthetic */ int access$900(HashMapObjectObjectElementsIterator x0) {
            return x0.prevPos;
        }
    }

    protected class HashMapObjectObjectKeysIterator
    implements ForwardIterator {
        private int i;
        private int prevPos;
        private int pos;
        private int start;
        private int end;
        private int counter;

        protected HashMapObjectObjectKeysIterator() {
            this.prevPos = this.i = 0;
            this.pos = HashMapObjectObject.this.nextPtr[this.i];
            this.start = 0;
            this.end = HashMapObjectObject.this.count;
            this.counter = this.start;
        }

        public Object get() {
            return HashMapObjectObject.this.iterGet(this, true);
        }

        public boolean isAtBegin() {
            return this.counter == this.start;
        }

        public boolean isAtEnd() {
            return this.counter == this.end;
        }

        public RootDataStructure getDataStructure() {
            return HashMapObjectObject.this;
        }

        public Object next() {
            return HashMapObjectObject.this.iterNext(this, 0, true);
        }

        public Object next(int n) {
            return HashMapObjectObject.this.iterNext(this, n, true);
        }

        public void setStartFromIterator(RootIterator iterator) {
            HashMapObjectObjectKeysIterator hmooki = (HashMapObjectObjectKeysIterator)iterator;
            if (HashMapObjectObject.this != hmooki.getDataStructure()) {
                throw new IteratorException("An attempt to set start from an Iterator over a different HashMapObjectObject instance!");
            }
            int newCounter = hmooki.counter;
            int newPos = hmooki.pos;
            int newPrevPos = hmooki.prevPos;
            int newI = hmooki.i;
            if (newCounter >= this.end) {
                throw new IteratorException("An attempt to set the start behind the end of the Iterator: " + newCounter + " >= " + this.end);
            }
            this.counter = this.start = newCounter;
            this.prevPos = newPrevPos;
            this.pos = newPos;
            this.i = newI;
        }

        public void setEndFromIterator(RootIterator iterator) {
            HashMapObjectObjectKeysIterator hmooki = (HashMapObjectObjectKeysIterator)iterator;
            if (HashMapObjectObject.this != hmooki.getDataStructure()) {
                throw new IteratorException("An attempt to set end from an Iterator over a different HashMapObjectObject instance!");
            }
            int newCounter = hmooki.counter;
            if (newCounter < this.counter) {
                throw new IteratorException(" end ahead of the current position of the Iterator: " + newCounter + " < " + this.counter);
            }
            this.end = newCounter;
        }

        public Object add(Object obj) {
            throw new IteratorException("Operation is not supported!");
        }

        public Object change(Object obj) {
            throw new IteratorException("Operation is not supported!");
        }

        public Object remove() {
            return HashMapObjectObject.this.iterRemove(this, true);
        }

        public Object insert(Object obj) {
            throw new IteratorException("Operation is not supported!");
        }

        public int size() {
            return this.end - this.start;
        }

        public boolean isInsertable() {
            return false;
        }

        public boolean isRemoveable() {
            return true;
        }

        public boolean isChangeable() {
            return false;
        }

        public boolean isAddable() {
            return false;
        }

        static /* synthetic */ int access$802(HashMapObjectObjectKeysIterator x0, int x1) {
            x0.prevPos = x1;
            return x0.prevPos;
        }

        static /* synthetic */ int access$302(HashMapObjectObjectKeysIterator x0, int x1) {
            x0.pos = x1;
            return x0.pos;
        }

        static /* synthetic */ int access$008(HashMapObjectObjectKeysIterator x0) {
            return x0.counter++;
        }

        static /* synthetic */ int access$208(HashMapObjectObjectKeysIterator x0) {
            return x0.i++;
        }

        static /* synthetic */ int access$800(HashMapObjectObjectKeysIterator x0) {
            return x0.prevPos;
        }
    }
}

