/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.util;

import com.sap.archtech.archconn.exceptions.XMLGenerationException;
import com.sap.archtech.archconn.util.GenerateXMLThread;
import com.sap.archtech.archconn.util.GenerateXSDThread;
import com.sap.engine.lib.xml.util.DOMSerializer;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLGenerator {
    private static final Location loc = Location.getLocation((String)"com.sap.archtech.archconn");
    private static final Category cat = Category.getCategory((Category)Category.APPS_COMMON_ARCHIVING, (String)"Connector");

    public InputStream genXMLdoc(int maxsize) throws XMLGenerationException, IOException {
        Text n = null;
        Document xmldoc = null;
        DOMSerializer domser = new DOMSerializer();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            DocumentBuilderFactory factory = (DocumentBuilderFactory)Class.forName("com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl").newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            xmldoc = builder.newDocument();
        }
        catch (ParserConfigurationException pacex) {
            cat.logThrowableT(500, loc, "XMLGenerator.genXMLdoc()", (Throwable)pacex);
            throw new XMLGenerationException("XMLGenerator: Parser Configuration Exception: " + pacex.getMessage());
        }
        catch (IllegalAccessException ilex) {
            cat.logThrowableT(500, loc, "XMLGenerator.genXMLdoc()", (Throwable)ilex);
            throw new XMLGenerationException("XMLGenerator: Illegal Access Exception: " + ilex.getMessage());
        }
        catch (InstantiationException instex) {
            cat.logThrowableT(500, loc, "XMLGenerator.genXMLdoc()", (Throwable)instex);
            throw new XMLGenerationException("XMLGenerator: Instantiation Exception: " + instex.getMessage());
        }
        catch (ClassNotFoundException clnfex) {
            cat.logThrowableT(500, loc, "XMLGenerator.genXMLdoc()", (Throwable)clnfex);
            throw new XMLGenerationException("XMLGenerator: ClassNotFound Exception: " + clnfex.getMessage());
        }
        Element root = xmldoc.createElement("personnel");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:noNamespaceSchemaLocation", "personal.xsd");
        int i = 0;
        while (i < maxsize) {
            Element person = xmldoc.createElementNS(null, "person");
            person.setAttribute("id", "worker_".concat(Integer.toString(i)));
            Element name = xmldoc.createElementNS(null, "name");
            Element family = xmldoc.createElementNS(null, "family");
            n = xmldoc.createTextNode("developer_".concat(Integer.toString(i)));
            family.appendChild(n);
            Element given = xmldoc.createElementNS(null, "given");
            n = xmldoc.createTextNode("poor_".concat(Integer.toString(i)));
            given.appendChild(n);
            Element email = xmldoc.createElementNS(null, "email");
            n = xmldoc.createTextNode("stupido_".concat(Integer.toString(i)).concat("@foo.com"));
            email.appendChild(n);
            name.appendChild(family);
            name.appendChild(given);
            person.appendChild(name);
            person.appendChild(email);
            root.appendChild(person);
            ++i;
        }
        xmldoc.appendChild(root);
        try {
            domser.write(xmldoc, (OutputStream)bos);
            bos.flush();
            bos.close();
        }
        catch (Exception ex) {
            cat.logThrowableT(500, loc, "XMLGenerator.genXMLdoc()", (Throwable)ex);
            throw new IOException("Problems creating XML: " + ex.getMessage());
        }
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public InputStream genXSDdoc() throws IOException {
        PipedOutputStream pipeOut = new PipedOutputStream();
        PipedInputStream pipeIn = new PipedInputStream(pipeOut);
        new GenerateXSDThread(pipeOut).start();
        return pipeIn;
    }

    public InputStream genXMLdoc2(int maxsize) throws IOException {
        PipedOutputStream pipeOut = new PipedOutputStream();
        PipedInputStream pipeIn = new PipedInputStream(pipeOut);
        new GenerateXMLThread(maxsize, pipeOut).start();
        return pipeIn;
    }
}

