/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.util;

public class URI {
    private String path;

    private URI() {
    }

    public URI(String str) {
        this.path = str;
    }

    public String toString() {
        return this.path;
    }

    public URI normalize() {
        return URI.normalize(this);
    }

    public URI relativize(URI uri) {
        return URI.relativize(this, uri);
    }

    public URI resolve(URI uri) {
        return URI.resolve(this, uri);
    }

    public URI resolve(String str) {
        return this.resolve(new URI(str));
    }

    private static URI normalize(URI u) {
        if (u.path == null || u.path.length() == 0) {
            return u;
        }
        String np = URI.normalize(u.path);
        if (np == u.path) {
            return u;
        }
        return new URI(np);
    }

    private static String normalize(String ps) {
        int ns = URI.needsNormalization(ps);
        if (ns < 0) {
            return ps;
        }
        char[] path = ps.toCharArray();
        int[] segs = new int[ns];
        URI.split(path, segs);
        URI.removeDots(path, segs);
        URI.maybeAddLeadingDot(path, segs);
        String s = new String(path, 0, URI.join(path, segs));
        if (s.equals(ps)) {
            return ps;
        }
        return s;
    }

    /*
     * Unable to fully structure code
     */
    private static int needsNormalization(String path) {
        normal = true;
        ns = 0;
        end = path.length() - 1;
        p = 0;
        while (p <= end) {
            if (path.charAt(p) != '/') break;
            ++p;
        }
        if (p > 1) {
            normal = false;
        }
        block1: while (p <= end) {
            if (path.charAt(p) == '.' && (p == end || path.charAt(p + 1) == '/' || path.charAt(p + 1) == '.' && (p + 1 == end || path.charAt(p + 2) == '/'))) {
                normal = false;
            }
            ++ns;
            while (p <= end) {
                if (path.charAt(p++) == '/') ** GOTO lbl21
                continue;
                while (path.charAt(p) == '/') {
                    normal = false;
                    ++p;
lbl21:
                    // 2 sources

                    if (p <= end) continue;
                    continue block1;
                }
                continue block1;
            }
        }
        return normal != false ? -1 : ns;
    }

    private static void split(char[] path, int[] segs) {
        int end = path.length - 1;
        int p = 0;
        int i = 0;
        while (p <= end) {
            if (path[p] != '/') break;
            path[p] = '\u0000';
            ++p;
        }
        block1: while (p <= end) {
            segs[i++] = p++;
            while (p <= end) {
                if (path[p++] != '/') continue;
                path[p - 1] = '\u0000';
                while (p <= end) {
                    if (path[p] != '/') continue block1;
                    path[p++] = '\u0000';
                }
                continue block1;
            }
        }
        if (i != segs.length) {
            throw new InternalError();
        }
    }

    private static int join(char[] path, int[] segs) {
        int ns = segs.length;
        int end = path.length - 1;
        int p = 0;
        if (path[p] == '\u0000') {
            path[p++] = 47;
        }
        int i = 0;
        while (i < ns) {
            int q = segs[i];
            if (q != -1) {
                if (p == q) {
                    while (p <= end && path[p] != '\u0000') {
                        ++p;
                    }
                    if (p <= end) {
                        path[p++] = 47;
                    }
                } else if (p < q) {
                    while (q <= end && path[q] != '\u0000') {
                        path[p++] = path[q++];
                    }
                    if (q <= end) {
                        path[p++] = 47;
                    }
                } else {
                    throw new InternalError();
                }
            }
            ++i;
        }
        return p;
    }

    private static void removeDots(char[] path, int[] segs) {
        int ns = segs.length;
        int end = path.length - 1;
        int i = 0;
        while (i < ns) {
            int dots = 0;
            do {
                int p;
                if (path[p = segs[i]] != '.') continue;
                if (p == end) {
                    dots = 1;
                    break;
                }
                if (path[p + 1] == '\u0000') {
                    dots = 1;
                    break;
                }
                if (path[p + 1] != '.' || p + 1 != end && path[p + 2] != '\u0000') continue;
                dots = 2;
                break;
            } while (++i < ns);
            if (i > ns || dots == 0) break;
            if (dots == 1) {
                segs[i] = -1;
            } else {
                int q;
                int j = i - 1;
                while (j >= 0) {
                    if (segs[j] != -1) break;
                    --j;
                }
                if (j >= 0 && (path[q = segs[j]] != '.' || path[q + 1] != '.' || path[q + 2] != '\u0000')) {
                    segs[i] = -1;
                    segs[j] = -1;
                }
            }
            ++i;
        }
    }

    private static void maybeAddLeadingDot(char[] path, int[] segs) {
        if (path[0] == '\u0000') {
            return;
        }
        int ns = segs.length;
        int f = 0;
        while (f < ns) {
            if (segs[f] >= 0) break;
            ++f;
        }
        if (f >= ns || f == 0) {
            return;
        }
        int p = segs[f];
        while (p < path.length && path[p] != ':' && path[p] != '\u0000') {
            ++p;
        }
        if (p >= path.length || path[p] == '\u0000') {
            return;
        }
        path[0] = 46;
        path[1] = '\u0000';
        segs[0] = 0;
    }

    private static URI resolve(URI base, URI child) {
        URI ru = new URI();
        String cp = child.path == null ? "" : child.path;
        ru.path = cp.length() > 0 && cp.charAt(0) == '/' ? child.path : URI.resolvePath(base.path, cp, false);
        return ru;
    }

    private static String resolvePath(String base, String child, boolean absolute) {
        int i = base.lastIndexOf(47);
        int cn = child.length();
        String path = "";
        if (cn == 0) {
            if (i >= 0) {
                path = base.substring(0, i + 1);
            }
        } else {
            StringBuffer sb = new StringBuffer(base.length() + cn);
            if (i >= 0) {
                sb.append(base.substring(0, i + 1));
            }
            sb.append(child);
            path = sb.toString();
        }
        String np = URI.normalize(path);
        return np;
    }

    private static URI relativize(URI base, URI child) {
        String cp;
        String bp = URI.normalize(base.path);
        if (!bp.equals(cp = URI.normalize(child.path))) {
            if (!bp.endsWith("/")) {
                bp = bp + "/";
            }
            if (!cp.startsWith(bp)) {
                return child;
            }
        }
        URI v = new URI();
        v.path = cp.substring(bp.length());
        return v;
    }
}

