/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.util;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PipedOutputStream;

public class GenerateXSDThread
extends Thread {
    private static final Location loc = Location.getLocation((String)"com.sap.archtech.archconn");
    private static final Category cat = Category.getCategory((Category)Category.APPS_COMMON_ARCHIVING, (String)"Connector");
    private PipedOutputStream ww;

    GenerateXSDThread(PipedOutputStream pw) {
        this.ww = pw;
    }

    public void run() {
        BufferedWriter sw = new BufferedWriter(new OutputStreamWriter(this.ww));
        try {
            sw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sw.write("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n");
            sw.write(" <xs:element name=\"personnel\">\n");
            sw.write("  <xs:complexType>\n");
            sw.write("   <xs:sequence>\n");
            sw.write("     <xs:element ref=\"person\" minOccurs='1' maxOccurs='unbounded'/>\n");
            sw.write("   </xs:sequence>\n");
            sw.write("  </xs:complexType>\n");
            sw.write("\t<xs:unique name=\"unique1\">\n");
            sw.write("\t <xs:selector xpath=\"person\"/>\n");
            sw.write("\t <xs:field xpath=\"name/given\"/>\n");
            sw.write("\t <xs:field xpath=\"name/family\"/>\n");
            sw.write("\t</xs:unique>\n");
            sw.write("\t<xs:key name='empid'>\n");
            sw.write("\t <xs:selector xpath=\"person\"/>\n");
            sw.write("\t <xs:field xpath=\"@id\"/>\n");
            sw.write("\t</xs:key>\n");
            sw.write("\t\t<xs:keyref name=\"keyref1\" refer='empid'>\n");
            sw.write("\t\t <xs:selector xpath=\"person\"/>\n");
            sw.write("\t\t <xs:field xpath=\"link/@manager\"/>\n");
            sw.write("\t\t</xs:keyref>\n");
            sw.write("\t  </xs:element>\n");
            sw.write("\t  <xs:element name=\"person\">\n");
            sw.write("\t\t<xs:complexType>\n");
            sw.write("\t\t <xs:sequence>\n");
            sw.write("\t\t\t<xs:element ref=\"name\"/>\n");
            sw.write("\t\t\t<xs:element ref=\"email\" minOccurs='0' maxOccurs='unbounded'/>\n");
            sw.write("\t\t\t<xs:element ref=\"url\"   minOccurs='0' maxOccurs='unbounded'/>\n");
            sw.write("\t\t\t<xs:element ref=\"link\"  minOccurs='0' maxOccurs='1'/>\n");
            sw.write("\t\t </xs:sequence>\n");
            sw.write("\t\t <xs:attribute name=\"id\"  type=\"xs:ID\" use='required'/>\n");
            sw.write("\t\t <xs:attribute name=\"note\" type=\"xs:string\"/>\n");
            sw.write("\t\t <xs:attribute name=\"contr\" default=\"false\">\n");
            sw.write("\t\t  <xs:simpleType>\n");
            sw.write("\t\t\t<xs:restriction base = \"xs:string\">\n");
            sw.write("\t\t\t  <xs:enumeration value=\"true\"/>\n");
            sw.write("\t\t\t  <xs:enumeration value=\"false\"/>\n");
            sw.write("\t\t\t</xs:restriction>\n");
            sw.write("\t\t  </xs:simpleType>\n");
            sw.write("\t\t </xs:attribute>\n");
            sw.write("\t\t <xs:attribute name=\"salary\" type=\"xs:integer\"/>\n");
            sw.write("\t\t</xs:complexType>\n");
            sw.write("\t  </xs:element>\n");
            sw.write("  <xs:element name=\"name\">\n");
            sw.write("\t<xs:complexType>\n");
            sw.write("\t <xs:all>\n");
            sw.write("\t  <xs:element ref=\"family\"/>\n");
            sw.write("\t  <xs:element ref=\"given\"/>\n");
            sw.write("\t </xs:all>\n");
            sw.write("\t</xs:complexType>\n");
            sw.write(" </xs:element>\n");
            sw.write(" <xs:element name=\"family\" type='xs:string'/>\n");
            sw.write(" <xs:element name=\"given\" type='xs:string'/>\n");
            sw.write(" <xs:element name=\"email\" type='xs:string'/>\n");
            sw.write(" <xs:element name=\"url\">\n");
            sw.write("\t<xs:complexType>\n");
            sw.write("\t <xs:attribute name=\"href\" type=\"xs:string\" default=\"http://\"/>\n");
            sw.write("\t</xs:complexType>\n");
            sw.write("  </xs:element>\n");
            sw.write("  <xs:element name=\"link\">\n");
            sw.write("\t<xs:complexType>\n");
            sw.write("\t <xs:attribute name=\"manager\" type=\"xs:IDREF\"/>\n");
            sw.write(" <xs:attribute name=\"subordinates\" type=\"xs:IDREFS\"/>\n");
            sw.write("\t</xs:complexType>\n");
            sw.write("</xs:element>\n");
            sw.write("<xs:notation name='gif' public='-//APP/Photoshop/4.0' system='photoshop.exe'/>\n");
            sw.write("</xs:schema>\n");
            sw.flush();
            sw.close();
        }
        catch (IOException ioex) {
            cat.logThrowableT(500, loc, "GenerateXSDThread.run()", (Throwable)ioex);
        }
    }
}

