/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.util;

import com.sap.engine.lib.xml.util.DOMSerializer;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class GenerateXMLThread
extends Thread {
    private static final Location loc = Location.getLocation((String)"com.sap.archtech.archconn");
    private static final Category cat = Category.getCategory((Category)Category.APPS_COMMON_ARCHIVING, (String)"Connector");
    private int maxsize;
    private PipedOutputStream pos;

    GenerateXMLThread(int maxsize, PipedOutputStream pos) {
        this.maxsize = maxsize;
        this.pos = pos;
    }

    public void run() {
        Text n = null;
        Document xmldoc = null;
        DOMSerializer domser = new DOMSerializer();
        try {
            DocumentBuilderFactory factory = (DocumentBuilderFactory)Class.forName("com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl").newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            xmldoc = builder.newDocument();
        }
        catch (ParserConfigurationException pacex) {
            cat.logThrowableT(500, loc, "GenerateXMLThread.run()", (Throwable)pacex);
        }
        catch (IllegalAccessException ilex) {
            cat.logThrowableT(500, loc, "GenerateXMLThread.run()", (Throwable)ilex);
        }
        catch (InstantiationException instex) {
            cat.logThrowableT(500, loc, "GenerateXMLThread.run()", (Throwable)instex);
        }
        catch (ClassNotFoundException clnfex) {
            cat.logThrowableT(500, loc, "GenerateXMLThread.run()", (Throwable)clnfex);
        }
        Element root = xmldoc.createElement("personnel");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:noNamespaceSchemaLocation", "personal.xsd");
        int i = 0;
        while (i < this.maxsize) {
            Element person = xmldoc.createElementNS(null, "person");
            person.setAttribute("id", "worker_".concat(Integer.toString(i)));
            Element name = xmldoc.createElementNS(null, "name");
            Element family = xmldoc.createElementNS(null, "family");
            n = xmldoc.createTextNode("developer_".concat(Integer.toString(i)));
            family.appendChild(n);
            Element given = xmldoc.createElementNS(null, "given");
            n = xmldoc.createTextNode("poor_".concat(Integer.toString(i)));
            given.appendChild(n);
            Element email = xmldoc.createElementNS(null, "email");
            n = xmldoc.createTextNode("stupido_".concat(Integer.toString(i)).concat("@foo.com"));
            email.appendChild(n);
            name.appendChild(family);
            name.appendChild(given);
            person.appendChild(name);
            person.appendChild(email);
            root.appendChild(person);
            ++i;
        }
        xmldoc.appendChild(root);
        try {
            domser.write(xmldoc, (OutputStream)this.pos);
            this.pos.flush();
            this.pos.close();
        }
        catch (Exception ex) {
            cat.logThrowableT(500, loc, "GenerateXMLThread.run()", (Throwable)ex);
        }
    }
}

