/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.util;

import com.sap.archtech.archconn.ArchCommand;
import com.sap.archtech.archconn.ArchResponse;
import com.sap.archtech.archconn.ArchSession;
import com.sap.archtech.archconn.ArchSessionFactory;
import com.sap.archtech.archconn.exceptions.ArchConnException;
import com.sap.archtech.archconn.exceptions.ArchServiceException;
import com.sap.archtech.archconn.util.URI;
import com.sap.archtech.archconn.values.ArchSetHome;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class ArchSetConfigurator {
    private static final String JDBC_PATH = "jdbc/SAP/BC_XMLA";
    private static final String GET_ASET_CONF1 = "SELECT * FROM bc_xmla_asets WHERE asetprop = ? AND init = ?";
    private static final String GET_ASET_CONF2 = "SELECT * FROM bc_xmla_asets WHERE asetname = ? AND asetprop = ? AND init = ?";
    private static final String UPD_ASET_CONF = "UPDATE bc_xmla_asets SET init = ? WHERE asetname = ? and asetprop = ?";
    private static final String SYSTEMPL = "<SYSID>";
    private static final String SYSPROP = "SAPSYSTEMNAME";
    private static final Location loc = Location.getLocation((String)"com.sap.archtech.archconn");
    private static final Category cat = Category.getCategory((Category)Category.APPS_COMMON_ARCHIVING, (String)"Connector");

    /*
     * Loose catch block
     */
    public static void createHomeAction(String user, String archsetname, boolean forSet) throws ArchConnException {
        block23: {
            String archhome;
            String archset;
            Statement pst1 = null;
            Statement pst2 = null;
            Connection conn = null;
            ArrayList<ArchSetHome> archsets = new ArrayList<ArchSetHome>();
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(JDBC_PATH);
            conn = ds.getConnection();
            conn.setAutoCommit(false);
            if (forSet) {
                pst1 = conn.prepareStatement(GET_ASET_CONF2);
                pst1.setString(1, archsetname.trim().toLowerCase());
                pst1.setString(2, "AHOME");
                pst1.setString(3, "N");
            } else {
                pst1 = conn.prepareStatement(GET_ASET_CONF1);
                pst1.setString(1, "AHOME");
                pst1.setString(2, "N");
            }
            pst2 = conn.prepareStatement(UPD_ASET_CONF);
            ResultSet rs1 = pst1.executeQuery();
            while (rs1.next()) {
                archset = rs1.getString("asetname").toLowerCase();
                archhome = rs1.getString("propvalue");
                int sysindex = archhome.indexOf(SYSTEMPL);
                if (sysindex >= 0) {
                    archhome = archhome.substring(0, sysindex) + System.getProperty(SYSPROP).toLowerCase() + archhome.substring(sysindex + SYSTEMPL.length(), archhome.length());
                }
                archsets.add(new ArchSetHome(archset, archhome));
            }
            rs1.close();
            ArchSessionFactory asf = ArchSessionFactory.getSessionFactory();
            ArchSession configsess = asf.getSession(user, "sapglobal");
            int i = 0;
            while (i < archsets.size()) {
                archset = ((ArchSetHome)archsets.get(i)).getArchset();
                archhome = ((ArchSetHome)archsets.get(i)).getHomepath();
                ArchCommand syncset = configsess.createCommand("SYNCHOMEPATH");
                syncset.addParam(new URI(archhome));
                syncset.addParam("action", "I");
                syncset.execute();
                ArchResponse resp = syncset.getResponse();
                int stcode = resp.getStatusCode();
                if (stcode != 200) {
                    throw new ArchServiceException("Creation of home path " + archhome + " for archiving set " + archset + " failed");
                }
                pst2.setString(1, "Y");
                pst2.setString(2, archset);
                pst2.setString(3, "AHOME");
                int count = pst2.executeUpdate();
                if (count != 1) {
                    throw new SQLException("Update Count on BC_XMLA_ASETS is " + count);
                }
                conn.commit();
                cat.infoT(loc, "Created home path {0} for archset {1}", new Object[]{archhome, archset});
                ++i;
            }
            Object var21_24 = null;
            try {
                if (pst1 != null) {
                    pst1.close();
                }
                if (pst2 != null) {
                    pst2.close();
                }
                if (conn != null) {
                    conn.commit();
                    conn.close();
                }
                break block23;
            }
            catch (SQLException sqlex2) {
                cat.logThrowableT(500, loc, "ArchSetConfigurator.createSetHome()", (Throwable)sqlex2);
            }
            break block23;
            {
                catch (NamingException namex) {
                    cat.logThrowableT(500, loc, "ArchSetConfigurator.createSetHome()", (Throwable)namex);
                    throw new ArchConnException(namex.getMessage());
                }
                catch (SQLException sqlex) {
                    cat.logThrowableT(500, loc, "ArchSetConfigurator.createSetHome()", (Throwable)sqlex);
                    throw new ArchConnException(sqlex.getMessage());
                }
                catch (ArchConnException acex) {
                    cat.logThrowableT(500, loc, "ArchSetConfigurator.createSetHome()", (Throwable)acex);
                    throw new ArchConnException(acex.getMessage());
                }
                catch (IOException ioex) {
                    cat.logThrowableT(500, loc, "ArchSetConfigurator.createSetHome()", (Throwable)ioex);
                    throw new ArchConnException(ioex.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var21_25 = null;
                try {
                    if (pst1 != null) {
                        pst1.close();
                    }
                    if (pst2 != null) {
                        pst2.close();
                    }
                    if (conn != null) {
                        conn.commit();
                        conn.close();
                    }
                }
                catch (SQLException sqlex2) {
                    cat.logThrowableT(500, loc, "ArchSetConfigurator.createSetHome()", (Throwable)sqlex2);
                }
                throw throwable;
            }
        }
    }

    public static void createSetHome(String user, String archset) throws ArchConnException {
        ArchSetConfigurator.createHomeAction(user, archset, true);
    }

    public static void createSetHome(String user) throws ArchConnException {
        ArchSetConfigurator.createHomeAction(user, null, false);
    }
}

