/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.util;

import com.sap.archtech.archconn.exceptions.ArchConfigException;
import com.sap.security.core.server.destinations.api.ConfigurationException;
import com.sap.security.core.server.destinations.api.Destination;
import com.sap.security.core.server.destinations.api.DestinationException;
import com.sap.security.core.server.destinations.api.DestinationService;
import com.sap.security.core.server.destinations.api.HTTPDestination;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class ArchConfigProviderSingle {
    private static final String SYSTEMPL = "<SYSID>";
    private static final String SYSPROP = "SAPSYSTEMNAME";
    private static final String INSTPROP = "SAPMYNAME";
    private static final String GET_AC_CONF = "SELECT asetprop, propvalue FROM bc_xmla_asets WHERE asetname = ?";
    private static final String GET_ASET_CONF = "SELECT * FROM bc_xmla_asets WHERE asetprop = ?";
    private static final String UPD_AC = "UPDATE bc_xmla_asets SET propvalue = ? WHERE asetname = ? AND asetprop = ?";
    private static final String UPD_STATUS = "UPDATE bc_xmla_asessions SET sessionstatus = ? WHERE sessionstatus = ? AND ainstance = ?";
    private static final Location loc = Location.getLocation((String)"com.sap.archtech.archconn");
    private static final Category cat = Category.getCategory((Category)Category.APPS_COMMON_ARCHIVING, (String)"Connector");
    private static ArchConfigProviderSingle acps = new ArchConfigProviderSingle();
    private Map archapplication;
    private Map archconn;
    private Map applrestart;
    private HTTPDestination httpDestination;
    private IConnectionTemplate httpTemplate;
    private DataSource ds;

    /*
     * Loose catch block
     */
    private ArchConfigProviderSingle() {
        block59: {
            String archhome;
            String archset;
            Connection conn = null;
            Statement pst1 = null;
            Statement pst2 = null;
            Statement pst4 = null;
            int updcount = 0;
            this.archapplication = new HashMap();
            this.archconn = new HashMap();
            this.applrestart = new HashMap();
            InitialContext ctx = new InitialContext();
            this.ds = (DataSource)ctx.lookup("jdbc/SAP/BC_XMLA");
            conn = this.getConnection();
            pst1 = conn.prepareStatement(GET_AC_CONF);
            pst2 = conn.prepareStatement(GET_ASET_CONF);
            pst1.setString(1, "bc_archconn_config");
            ResultSet rs1 = pst1.executeQuery();
            while (rs1.next()) {
                this.archconn.put(rs1.getString("ASETPROP"), rs1.getString("propvalue"));
            }
            rs1.close();
            if (this.archconn.isEmpty()) {
                loc.errorT("Found no configuration for archiving connector");
            }
            pst2.setString(1, "AHOME");
            ResultSet rs2 = pst2.executeQuery();
            while (rs2.next()) {
                archset = rs2.getString("asetname").toLowerCase();
                archhome = rs2.getString("propvalue");
                int sysindex = archhome.indexOf(SYSTEMPL);
                if (sysindex >= 0) {
                    archhome = archhome.substring(0, sysindex) + System.getProperty(SYSPROP).toLowerCase() + archhome.substring(sysindex + SYSTEMPL.length(), archhome.length());
                }
                this.archapplication.put(archset, archhome);
            }
            rs2.close();
            pst2.setString(1, "WSTART");
            ResultSet rsw = pst2.executeQuery();
            while (rsw.next()) {
                archset = rsw.getString("asetname").toLowerCase();
                archhome = rsw.getString("propvalue").toLowerCase();
                this.applrestart.put(archset, archhome);
            }
            rsw.close();
            String instance = System.getProperty(INSTPROP);
            pst4 = conn.prepareStatement(UPD_STATUS);
            pst4.setString(1, "BRW");
            pst4.setString(2, "OPW");
            pst4.setString(3, instance);
            updcount = pst4.executeUpdate();
            if (updcount != 0) {
                cat.infoT(loc, "Set " + updcount + " write session(s) to broken");
                updcount = 0;
            }
            pst4.setString(1, "BRD");
            pst4.setString(2, "OPD");
            pst4.setString(3, instance);
            updcount = pst4.executeUpdate();
            if (updcount != 0) {
                cat.infoT(loc, "Set " + updcount + " delete session(s) to broken");
                updcount = 0;
            }
            pst4.setString(1, "BRK");
            pst4.setString(2, "OPN");
            pst4.setString(3, instance);
            pst4.executeUpdate();
            if (updcount != 0) {
                cat.infoT(loc, "Set " + updcount + " one phase session(s) to broken");
                updcount = 0;
            }
            ClassLoader saveLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Object obj = ctx.lookup("tc~sec~destinations~service");
            DestinationService dstService = (DestinationService)obj;
            if (dstService == null) {
                throw new NamingException("Destination service not available");
            }
            Destination destination = dstService.getDestination("HTTP", this.getArchDest());
            this.httpDestination = (HTTPDestination)destination;
            Thread.currentThread().setContextClassLoader(saveLoader);
            this.httpTemplate = this.httpDestination.getHTTPConnectionTemplate();
            Object var19_24 = null;
            try {
                if (pst1 != null) {
                    pst1.close();
                }
                if (pst2 != null) {
                    pst2.close();
                }
                if (pst4 != null) {
                    pst4.close();
                }
                if (conn != null) {
                    conn.commit();
                    conn.close();
                }
                break block59;
            }
            catch (SQLException sqlex2) {
                cat.logThrowableT(500, loc, "ArchConfigProviderSingle()", (Throwable)sqlex2);
            }
            break block59;
            {
                catch (NamingException namex) {
                    cat.logThrowableT(500, loc, "ArchConfigProviderSingle()", (Throwable)namex);
                    Object var19_25 = null;
                    try {
                        if (pst1 != null) {
                            pst1.close();
                        }
                        if (pst2 != null) {
                            pst2.close();
                        }
                        if (pst4 != null) {
                            pst4.close();
                        }
                        if (conn != null) {
                            conn.commit();
                            conn.close();
                        }
                        break block59;
                    }
                    catch (SQLException sqlex2) {
                        cat.logThrowableT(500, loc, "ArchConfigProviderSingle()", (Throwable)sqlex2);
                    }
                    break block59;
                }
                catch (SQLException sqlex) {
                    cat.logThrowableT(500, loc, "ArchConfigProviderSingle()", (Throwable)sqlex);
                    Object var19_26 = null;
                    try {
                        if (pst1 != null) {
                            pst1.close();
                        }
                        if (pst2 != null) {
                            pst2.close();
                        }
                        if (pst4 != null) {
                            pst4.close();
                        }
                        if (conn != null) {
                            conn.commit();
                            conn.close();
                        }
                        break block59;
                    }
                    catch (SQLException sqlex2) {
                        cat.logThrowableT(500, loc, "ArchConfigProviderSingle()", (Throwable)sqlex2);
                    }
                    break block59;
                }
                catch (IOException ioex) {
                    cat.logThrowableT(500, loc, "ArchConfigProviderSingle()", (Throwable)ioex);
                    Object var19_27 = null;
                    try {
                        if (pst1 != null) {
                            pst1.close();
                        }
                        if (pst2 != null) {
                            pst2.close();
                        }
                        if (pst4 != null) {
                            pst4.close();
                        }
                        if (conn != null) {
                            conn.commit();
                            conn.close();
                        }
                        break block59;
                    }
                    catch (SQLException sqlex2) {
                        cat.logThrowableT(500, loc, "ArchConfigProviderSingle()", (Throwable)sqlex2);
                    }
                    break block59;
                }
                catch (DestinationException dstex) {
                    cat.logThrowableT(500, loc, "ArchConfigProviderSingle()", (Throwable)dstex);
                    Object var19_28 = null;
                    try {
                        if (pst1 != null) {
                            pst1.close();
                        }
                        if (pst2 != null) {
                            pst2.close();
                        }
                        if (pst4 != null) {
                            pst4.close();
                        }
                        if (conn != null) {
                            conn.commit();
                            conn.close();
                        }
                        break block59;
                    }
                    catch (SQLException sqlex2) {
                        cat.logThrowableT(500, loc, "ArchConfigProviderSingle()", (Throwable)sqlex2);
                    }
                    break block59;
                }
                catch (ConfigurationException cnfex) {
                    cat.logThrowableT(500, loc, "ArchConfigProviderSingle()", (Throwable)cnfex);
                    Object var19_29 = null;
                    try {
                        if (pst1 != null) {
                            pst1.close();
                        }
                        if (pst2 != null) {
                            pst2.close();
                        }
                        if (pst4 != null) {
                            pst4.close();
                        }
                        if (conn != null) {
                            conn.commit();
                            conn.close();
                        }
                        break block59;
                    }
                    catch (SQLException sqlex2) {
                        cat.logThrowableT(500, loc, "ArchConfigProviderSingle()", (Throwable)sqlex2);
                    }
                    break block59;
                }
                catch (ArchConfigException acex) {
                    cat.logThrowableT(500, loc, "ArchConfigProviderSingle()", (Throwable)acex);
                    Object var19_30 = null;
                    try {
                        if (pst1 != null) {
                            pst1.close();
                        }
                        if (pst2 != null) {
                            pst2.close();
                        }
                        if (pst4 != null) {
                            pst4.close();
                        }
                        if (conn != null) {
                            conn.commit();
                            conn.close();
                        }
                        break block59;
                    }
                    catch (SQLException sqlex2) {
                        cat.logThrowableT(500, loc, "ArchConfigProviderSingle()", (Throwable)sqlex2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var19_31 = null;
                try {
                    if (pst1 != null) {
                        pst1.close();
                    }
                    if (pst2 != null) {
                        pst2.close();
                    }
                    if (pst4 != null) {
                        pst4.close();
                    }
                    if (conn != null) {
                        conn.commit();
                        conn.close();
                    }
                }
                catch (SQLException sqlex2) {
                    cat.logThrowableT(500, loc, "ArchConfigProviderSingle()", (Throwable)sqlex2);
                }
                throw throwable;
            }
        }
        this.archapplication.put("sapglobal", "/");
    }

    public String getArchDest() throws ArchConfigException {
        String archdest = (String)this.archconn.get("ARCHDEST");
        if (archdest == null) {
            throw new ArchConfigException("Found no configuration for archiving connector");
        }
        return archdest;
    }

    public String getArchProt() throws ArchConfigException {
        return "HTTP";
    }

    public String getArchProtLib() throws ArchConfigException {
        String archprotclient = (String)this.archconn.get("ARCHPROTLIB");
        if (archprotclient == null) {
            throw new ArchConfigException("Found no configuration for archiving connector");
        }
        return archprotclient;
    }

    public String getArchSetHome(String aset) throws ArchConfigException {
        String archappl = (String)this.archapplication.get(aset = aset.toLowerCase());
        if (archappl == null) {
            throw new ArchConfigException("Found no configuration for application " + aset);
        }
        return (String)this.archapplication.get(aset);
    }

    public int getUpdFrequency() throws ArchConfigException {
        String updfreq = (String)this.archconn.get("UPDFREQ");
        if (updfreq == null) {
            throw new ArchConfigException("Found no configuration for archiving connector");
        }
        return Integer.parseInt(updfreq);
    }

    public int getReadTimeout() throws ArchConfigException {
        String readto = (String)this.archconn.get("READTIMEOUT");
        if (readto == null) {
            throw new ArchConfigException("Found no configuration for archiving connector");
        }
        return Integer.parseInt(readto);
    }

    public int getConnectTimeout() throws ArchConfigException {
        String connectto = (String)this.archconn.get("CONNECTTIMEOUT");
        if (connectto == null) {
            throw new ArchConfigException("Found no configuration for archiving connector");
        }
        return Integer.parseInt(connectto);
    }

    public int getExpTimeout() throws ArchConfigException {
        String expto = (String)this.archconn.get("EXPIRATIONTIMEOUT");
        if (expto == null) {
            throw new ArchConfigException("Found no configuration for archiving connector");
        }
        return Integer.parseInt(expto);
    }

    public boolean getApplRestart(String archset) {
        return this.applrestart.get(archset) != null;
    }

    public static ArchConfigProviderSingle getArchConfigProviderSingle() {
        return acps;
    }

    public IConnectionTemplate getHttpTemplate() {
        return this.httpTemplate;
    }

    public void readArchconProps() throws SQLException {
        Connection con;
        block6: {
            PreparedStatement pst1 = null;
            con = this.getConnection();
            this.archconn.clear();
            try {
                pst1 = con.prepareStatement(GET_AC_CONF);
                pst1.setString(1, "bc_archconn_config");
                ResultSet rs1 = pst1.executeQuery();
                while (rs1.next()) {
                    this.archconn.put(rs1.getString("ASETPROP"), rs1.getString("propvalue"));
                }
                rs1.close();
                Object var5_4 = null;
                if (pst1 == null) break block6;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (pst1 != null) {
                    pst1.close();
                }
                if (con != null) {
                    con.commit();
                    con.close();
                }
                throw throwable;
            }
            pst1.close();
        }
        if (con != null) {
            con.commit();
            con.close();
        }
    }

    public int setArchconn(String asethome, String property, String value) throws SQLException {
        int updates;
        Connection con;
        block5: {
            PreparedStatement pst3 = null;
            con = null;
            try {
                con = this.getConnection();
                pst3 = con.prepareStatement(UPD_AC);
                pst3.setString(1, value);
                pst3.setString(2, asethome);
                pst3.setString(3, property);
                updates = pst3.executeUpdate();
                Object var8_7 = null;
                if (pst3 == null) break block5;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (pst3 != null) {
                    pst3.close();
                }
                if (con != null) {
                    con.commit();
                    con.close();
                }
                throw throwable;
            }
            pst3.close();
        }
        if (con != null) {
            con.commit();
            con.close();
        }
        return updates;
    }

    private Connection getConnection() throws SQLException {
        Connection conn = this.ds.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }
}

