/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.httpclients;

import com.sap.archtech.archconn.ArchResponse;
import com.sap.archtech.archconn.DefaultArchResponse;
import com.sap.archtech.archconn.httpclients.ArchHTTPClient;
import com.sap.security.core.server.destinations.api.ConfigurationException;
import com.sap.security.core.server.destinations.api.Destination;
import com.sap.security.core.server.destinations.api.DestinationException;
import com.sap.security.core.server.destinations.api.DestinationService;
import com.sap.security.core.server.destinations.api.HTTPDestination;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class W3CdserviceClient
implements ArchHTTPClient {
    private static final Location loc = Location.getLocation((String)"com.sap.archtech.archconn");
    private static final Category cat = Category.getCategory((Category)Category.APPS_COMMON_ARCHIVING, (String)"Connector");
    private HTTPDestination httpDestination;

    public W3CdserviceClient(String dest, String protocol) throws IOException {
        try {
            ClassLoader saveLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup("tc~sec~destinations~service");
            DestinationService dstService = (DestinationService)obj;
            Thread.currentThread().setContextClassLoader(saveLoader);
            if (dstService == null) {
                throw new NamingException("Destination service not available");
            }
            Destination destination = dstService.getDestination(protocol, dest);
            this.httpDestination = (HTTPDestination)destination;
        }
        catch (NamingException nmex) {
            cat.logThrowableT(500, loc, "W3CdserviceClient()", (Throwable)nmex);
            throw new IOException(nmex.getMessage());
        }
        catch (DestinationException dstex) {
            cat.logThrowableT(500, loc, "W3CdserviceClient()", (Throwable)dstex);
            throw new IOException(dstex.getMessage());
        }
    }

    public ArchResponse executeRequest(HashMap params) throws IOException {
        boolean hasStream = false;
        DefaultArchResponse resp = null;
        HttpURLConnection connection = this.getConFromDestService();
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (entry.getKey().equals("STREAM")) {
                hasStream = true;
                continue;
            }
            connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
        if (hasStream) {
            connection.setDoOutput(true);
            BufferedOutputStream bos = new BufferedOutputStream(connection.getOutputStream());
            BufferedInputStream bis = new BufferedInputStream((InputStream)params.get("STREAM"));
            int i2 = 0;
            while ((i2 = bis.read()) != -1) {
                bos.write(i2);
            }
            bos.flush();
            bos.close();
            bis.close();
        }
        connection.connect();
        String acommand = (String)params.get("method");
        if (params.get("submethod") != null) {
            acommand = acommand.concat((String)params.get("submethod"));
        }
        resp = new DefaultArchResponse(connection, acommand);
        return resp;
    }

    private HttpURLConnection getConFromDestService() throws IOException {
        try {
            return this.httpDestination.getURLConnection("POST");
        }
        catch (ConfigurationException cfex) {
            cat.logThrowableT(500, loc, "W3CdserviceClient().getConFromDestService()", (Throwable)cfex);
            throw new IOException(cfex.getMessage());
        }
    }
}

