/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.httpclients;

import com.sap.archtech.archconn.ArchResponse;
import com.sap.archtech.archconn.DTRHTTPArchResponse;
import com.sap.archtech.archconn.httpclients.ArchHTTPClient;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.StreamEntity;
import com.tssap.dtr.client.lib.protocol.requests.http.PostRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DTRdserviceClient
implements ArchHTTPClient {
    private static final Location loc = Location.getLocation((String)"com.sap.archtech.archconn");
    private static final Category cat = Category.getCategory((Category)Category.APPS_COMMON_ARCHIVING, (String)"Connector");
    private static final int READBUFFER = 1024;
    private IConnection conn;
    private IConnectionTemplate httpTemplate;

    public DTRdserviceClient(IConnectionTemplate httpTemplate, IConnection conn) {
        this.httpTemplate = httpTemplate;
        this.conn = conn;
    }

    public ArchResponse executeRequest(HashMap params) throws IOException {
        IResponse httpresp;
        String desturl = this.httpTemplate.getBasePath();
        if (desturl.endsWith("/")) {
            desturl = desturl.substring(0, desturl.length() - 1);
        }
        InputStream in = (InputStream)params.get("STREAM");
        PostRequest preq = new PostRequest(desturl);
        try {
            if (in != null) {
                StreamEntity body = new StreamEntity(in, "application/octet-stream");
                preq.setRequestEntity((IRequestEntity)body);
                Iterator i = params.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    if (entry.getKey().equals("STREAM")) continue;
                    preq.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            } else {
                Iterator i = params.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    preq.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            httpresp = this.conn.send((IRequest)preq);
        }
        catch (HTTPException httpex) {
            cat.logThrowableT(500, loc, "DTRdserviceClient().execute()", (Throwable)httpex);
            throw new IOException(httpex.getMessage());
        }
        String acommand = (String)params.get("method");
        if (params.get("submethod") != null) {
            acommand = acommand.concat((String)params.get("submethod"));
        }
        DTRHTTPArchResponse resp = new DTRHTTPArchResponse(httpresp, acommand);
        return resp;
    }
}

