/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.commands;

import com.sap.archtech.archconn.ArchResponse;
import com.sap.archtech.archconn.LocalArchResponse;
import com.sap.archtech.archconn.commands.AbstractArchCommand;
import com.sap.archtech.archconn.httpclients.ArchHTTPClient;
import com.sap.archtech.archconn.util.URI;
import com.sap.archtech.archconn.values.SessionInfo;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class SessioninfoCommand
extends AbstractArchCommand {
    private static final Location loc = Location.getLocation((String)"com.sap.archtech.archconn.commands.SessioninfoCommand");
    private static final String GET_STATUS = "SELECT * FROM BC_XMLA_ASESSIONS WHERE coluri = ?";

    protected SessioninfoCommand(String session, String collection, ArchHTTPClient client, String archuser) {
        super(session, archuser);
        this.client = client;
    }

    /*
     * Loose catch block
     */
    public void execute() throws IOException {
        LocalArchResponse lresp;
        block26: {
            Connection conn = null;
            Statement pst1 = null;
            ResultSet rs1 = null;
            SessionInfo sinfo = null;
            lresp = new LocalArchResponse("SESSIONINFO");
            String uri = (String)this.headerFields.get("uri");
            if (uri == null) {
                this.setError(lresp, 498, "URI not specified");
            } else {
                block25: {
                    InitialContext ctx = new InitialContext();
                    DataSource ds = (DataSource)ctx.lookup("jdbc/SAP/BC_XMLA");
                    conn = ds.getConnection();
                    conn.setAutoCommit(false);
                    pst1 = conn.prepareStatement(GET_STATUS);
                    pst1.setString(1, uri.toLowerCase());
                    rs1 = pst1.executeQuery();
                    if (!rs1.next()) {
                        this.setError(lresp, 488, "No archiving session found for this URI");
                        break block25;
                    }
                    sinfo = new SessionInfo(rs1.getString("coluri").concat("/"), rs1.getLong("wcount"), rs1.getLong("dcount"), rs1.getString("sessiontype"), rs1.getString("sessionstatus"), rs1.getString("sessionuser"), rs1.getString("comment"), rs1.getTimestamp("wsessionstart"), rs1.getTimestamp("wsessionstop"), rs1.getTimestamp("dsessionstart"), rs1.getTimestamp("dsessionstop"));
                    lresp.setSinfo(sinfo);
                    lresp.setErrmessage(null);
                    lresp.setService_message("Ok");
                    lresp.setStcode(200);
                    lresp.setProtmessage("Ok");
                }
                Object var10_11 = null;
                try {
                    if (rs1 != null) {
                        rs1.close();
                    }
                    if (pst1 != null) {
                        pst1.close();
                    }
                    if (conn != null) {
                        conn.commit();
                        conn.close();
                    }
                    break block26;
                }
                catch (SQLException sqlex2) {
                    loc.throwing("SESSIONINFO", (Throwable)sqlex2);
                    this.setError(lresp, 599, sqlex2.getMessage());
                }
            }
            break block26;
            {
                catch (SQLException sqlex) {
                    loc.throwing("SESSIONINFO", (Throwable)sqlex);
                    this.setError(lresp, 599, sqlex.getMessage());
                    Object var10_12 = null;
                    try {
                        if (rs1 != null) {
                            rs1.close();
                        }
                        if (pst1 != null) {
                            pst1.close();
                        }
                        if (conn != null) {
                            conn.commit();
                            conn.close();
                        }
                        break block26;
                    }
                    catch (SQLException sqlex2) {
                        loc.throwing("SESSIONINFO", (Throwable)sqlex2);
                        this.setError(lresp, 599, sqlex2.getMessage());
                    }
                    break block26;
                }
                catch (NamingException namex) {
                    loc.throwing("SESSIONINFO", (Throwable)namex);
                    this.setError(lresp, 599, namex.getMessage());
                    Object var10_13 = null;
                    try {
                        if (rs1 != null) {
                            rs1.close();
                        }
                        if (pst1 != null) {
                            pst1.close();
                        }
                        if (conn != null) {
                            conn.commit();
                            conn.close();
                        }
                        break block26;
                    }
                    catch (SQLException sqlex2) {
                        loc.throwing("SESSIONINFO", (Throwable)sqlex2);
                        this.setError(lresp, 599, sqlex2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    if (rs1 != null) {
                        rs1.close();
                    }
                    if (pst1 != null) {
                        pst1.close();
                    }
                    if (conn != null) {
                        conn.commit();
                        conn.close();
                    }
                }
                catch (SQLException sqlex2) {
                    loc.throwing("SESSIONINFO", (Throwable)sqlex2);
                    this.setError(lresp, 599, sqlex2.getMessage());
                }
                throw throwable;
            }
        }
        this.response = lresp;
    }

    public void addParam(URI uri) {
        String colname = uri.toString();
        if (colname.length() > 1 && colname.endsWith("/")) {
            colname = colname.substring(0, colname.length() - 1);
        }
        super.addParam("uri", colname);
    }

    public ArchResponse getResponse() {
        return this.response;
    }

    private void setError(LocalArchResponse lresp, int errorcode, String errormessage) {
        lresp.setStcode(errorcode);
        lresp.setErrmessage(errormessage);
        lresp.setProtmessage(null);
        lresp.setService_message(Integer.toString(errorcode) + " " + errormessage);
    }
}

