/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.commands;

import com.sap.archtech.archconn.commands.AbstractArchCommand;
import com.sap.archtech.archconn.exceptions.MethodNotApplicableException;
import com.sap.archtech.archconn.httpclients.ArchHTTPClient;
import com.sap.archtech.archconn.util.URI;
import com.sap.archtech.archconn.values.SelectClause;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class SelectCommand
extends AbstractArchCommand {
    private boolean clauseadded = false;

    protected SelectCommand(String session, String collection, ArchHTTPClient client, String archuser) {
        super(session, archuser);
        this.client = client;
        this.headerFields.put("method", "SELECT");
    }

    public void addParam(SelectClause slc) throws IOException, MethodNotApplicableException {
        if (this.clauseadded) {
            throw new IOException("SelectClause parameter added twice");
        }
        this.clauseadded = true;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oser = new ObjectOutputStream(bos);
        oser.writeObject(slc);
        bos.flush();
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        bos.close();
        oser.close();
        this.headerFields.put("STREAM", bis);
    }

    public void addParam(URI uri) {
        super.addParam("archive_path", uri.toString());
    }
}

