/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.commands;

import com.sap.archtech.archconn.commands.AbstractArchCommand;
import com.sap.archtech.archconn.httpclients.ArchHTTPClient;
import com.sap.archtech.archconn.util.URI;
import com.sap.archtech.archconn.values.IndexPropValues;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;

public class PutCommand
extends AbstractArchCommand {
    private boolean bodyadded = false;
    private ArrayList indexPropList;

    protected PutCommand(String session, String collection, ArchHTTPClient client, String archuser) {
        super(session, archuser);
        this.client = client;
        this.indexPropList = new ArrayList();
        this.headerFields.put("method", "PUT");
        if (collection != null) {
            this.headerFields.put("archive_path", collection);
        }
    }

    public void addParam(InputStream in1) throws IOException {
        if (in1 == null) {
            return;
        }
        if (this.bodyadded) {
            throw new IOException("InputStream parameter added twice");
        }
        if (this.indexPropList.size() == 0) {
            this.headerFields.put("index_count", "0");
            this.headerFields.put("STREAM", in1);
        } else {
            this.headerFields.put("index_count", String.valueOf(this.indexPropList.size()));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oser = new ObjectOutputStream(bos);
            int j = 0;
            while (j < this.indexPropList.size()) {
                oser.writeObject((IndexPropValues)this.indexPropList.get(j));
                ++j;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            SequenceInputStream sin = new SequenceInputStream(bis, in1);
            bos.flush();
            bos.close();
            oser.close();
            this.headerFields.put("STREAM", sin);
        }
        this.bodyadded = true;
    }

    public void addParam(IndexPropValues ipv) throws IOException {
        if (ipv == null) {
            return;
        }
        if (this.bodyadded) {
            throw new IOException("Index Property Values added after InputStream");
        }
        this.indexPropList.add(ipv);
    }

    public void addParam(URI uri) {
        if (this.headerFields.get("archive_path") == null) {
            super.addParam("archive_path", uri.toString());
        }
    }
}

