/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.commands;

import com.sap.archtech.archconn.commands.AbstractArchCommand;
import com.sap.archtech.archconn.httpclients.ArchHTTPClient;
import com.sap.archtech.archconn.util.URI;
import com.sap.archtech.archconn.values.IndexPropValues;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Iterator;
import java.util.Map;

public class IndexinsertCommand
extends AbstractArchCommand {
    protected IndexinsertCommand(String session, String collection, ArchHTTPClient client, String archuser) {
        super(session, archuser);
        this.client = client;
        this.headerFields.put("method", "INDEX");
        this.headerFields.put("submethod", "INSERT");
        if (collection != null) {
            this.headerFields.put("archive_path", collection);
        }
    }

    public void addParam(IndexPropValues ipv) throws IOException {
        String index = ipv.getIndexname();
        Iterator i = ipv.getPropVals().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            index = index.concat("#" + entry.getKey() + "=" + entry.getValue());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(index.getBytes("UTF-8"));
        bos.write(13);
        bos.write(10);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        bos.flush();
        bos.close();
        if (this.headerFields.get("STREAM") != null) {
            InputStream in = (InputStream)this.headerFields.get("STREAM");
            SequenceInputStream sin = new SequenceInputStream(in, bis);
            this.headerFields.put("STREAM", sin);
        } else {
            this.headerFields.put("STREAM", bis);
        }
    }

    public void addParam(URI uri) {
        if (this.headerFields.get("archive_path") == null) {
            super.addParam("archive_path", uri.toString());
        }
    }
}

