/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.commands;

import com.sap.archtech.archconn.commands.AbstractArchCommand;
import com.sap.archtech.archconn.httpclients.ArchHTTPClient;
import com.sap.archtech.archconn.values.IndexPropDescription;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class IndexcreateCommand
extends AbstractArchCommand {
    private boolean ipdadded = false;

    protected IndexcreateCommand(String session, String collection, ArchHTTPClient client, String archuser) {
        super(session, archuser);
        this.client = client;
        this.headerFields.put("method", "INDEX");
        this.headerFields.put("submethod", "CREATE");
    }

    public void addParam(IndexPropDescription ipd) throws IOException {
        if (ipd == null) {
            return;
        }
        if (this.ipdadded) {
            throw new IOException("IndexPropDescription parameter added twice");
        }
        this.headerFields.put("index_name", ipd.getIndexname());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Iterator i = ipd.getPropDesc().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String descline = (String)entry.getKey() + ":" + (String)entry.getValue();
            bos.write(descline.getBytes("UTF-8"));
            bos.write(13);
            bos.write(10);
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
        bos.close();
        this.headerFields.put("STREAM", bin);
        this.ipdadded = true;
    }
}

