/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.commands;

import com.sap.archtech.archconn.ArchCommand;
import com.sap.archtech.archconn.commands.AbstractArchCommand;
import com.sap.archtech.archconn.commands.CheckCommand;
import com.sap.archtech.archconn.commands.DeleteCommand;
import com.sap.archtech.archconn.commands.DeletionMarkCommand;
import com.sap.archtech.archconn.commands.GetCommand;
import com.sap.archtech.archconn.commands.HeadCommand;
import com.sap.archtech.archconn.commands.IndexcreateCommand;
import com.sap.archtech.archconn.commands.IndexdescribeCommand;
import com.sap.archtech.archconn.commands.IndexdropCommand;
import com.sap.archtech.archconn.commands.IndexgetCommand;
import com.sap.archtech.archconn.commands.IndexinsertCommand;
import com.sap.archtech.archconn.commands.InfoCommand;
import com.sap.archtech.archconn.commands.ListCommand;
import com.sap.archtech.archconn.commands.MPathCommand;
import com.sap.archtech.archconn.commands.MkcolCommand;
import com.sap.archtech.archconn.commands.PackCommand;
import com.sap.archtech.archconn.commands.PackStatusCommand;
import com.sap.archtech.archconn.commands.PickCommand;
import com.sap.archtech.archconn.commands.PutCommand;
import com.sap.archtech.archconn.commands.ResetDelstatCommand;
import com.sap.archtech.archconn.commands.SelectCommand;
import com.sap.archtech.archconn.commands.SessioninfoCommand;
import com.sap.archtech.archconn.commands.SyncHPCommand;
import com.sap.archtech.archconn.commands.UnpackCommand;
import com.sap.archtech.archconn.exceptions.UnsupportedCommandException;
import com.sap.archtech.archconn.httpclients.ArchHTTPClient;
import com.sap.archtech.archconn.util.URI;
import java.util.Arrays;
import java.util.HashMap;

public class ArchCommandFactory {
    private static final int MKCOL = 0;
    private static final int PUT = 1;
    private static final int DELETE = 2;
    private static final int GET = 3;
    private static final int INDEXCREATE = 4;
    private static final int INDEXDESCRIBE = 5;
    private static final int LIST = 6;
    private static final int SELECT = 7;
    private static final int PICK = 8;
    private static final int HEAD = 9;
    private static final int MODIFYPATH = 10;
    private static final int INDEXDROP = 11;
    private static final int INDEXGET = 12;
    private static final int INDEXINSERT = 13;
    private static final int CHECK = 14;
    private static final int INFO = 15;
    private static final int SESSIONINFO = 16;
    private static final int SYNCHOMEPATH = 17;
    private static final int DELETIONMARK = 18;
    private static final int PACK = 19;
    private static final int UNPACK = 20;
    private static final int PACKSTATUS = 21;
    private static final int RESETDELSTATUS = 22;
    private final int[] qcommands = new int[]{4, 5, 13, 11, 8, 1, 18};
    private final int[] ucommands = new int[]{8, 1, 18};
    private String[] archCommands = new String[]{"mkcol", "put", "delete", "get", "indexcreate", "indexdescribe", "list", "select", "pick", "head", "modifypath", "indexdrop", "indexget", "indexinsert", "check", "info", "sessioninfo", "synchomepath", "deletionmark", "pack", "unpack", "packstatus", "_reset_delstat"};
    private HashMap archMap = new HashMap();
    private static ArchCommandFactory acf = new ArchCommandFactory();

    private ArchCommandFactory() {
        int i = 0;
        while (i < this.archCommands.length) {
            this.archMap.put(this.archCommands[i], new Integer(i));
            ++i;
        }
        Arrays.sort(this.qcommands);
        Arrays.sort(this.ucommands);
    }

    public ArchCommand getArchCommand(String command, String shandle, URI coll, ArchHTTPClient httpclient, String archuser, boolean qualified) throws UnsupportedCommandException {
        AbstractArchCommand acomm = null;
        String lowcommand = command.toLowerCase();
        String collection = coll == null ? null : coll.toString();
        Integer commin = (Integer)this.archMap.get(lowcommand);
        if (commin == null) {
            throw new UnsupportedCommandException("Command " + command + " is not a valid archiving command");
        }
        if (qualified && Arrays.binarySearch(this.qcommands, commin) < 0) {
            throw new UnsupportedCommandException("Command " + command + " is not allowed in a qualified archiving session");
        }
        if (!qualified && Arrays.binarySearch(this.ucommands, commin) >= 0) {
            throw new UnsupportedCommandException("Command " + command + " is not allowed in an unqualified archiving session");
        }
        switch (commin) {
            case 0: {
                acomm = new MkcolCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 1: {
                acomm = new PutCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 2: {
                acomm = new DeleteCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 3: {
                acomm = new GetCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 4: {
                acomm = new IndexcreateCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 5: {
                acomm = new IndexdescribeCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 6: {
                acomm = new ListCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 7: {
                acomm = new SelectCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 8: {
                acomm = new PickCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 9: {
                acomm = new HeadCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 10: {
                acomm = new MPathCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 11: {
                acomm = new IndexdropCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 12: {
                acomm = new IndexgetCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 13: {
                acomm = new IndexinsertCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 14: {
                acomm = new CheckCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 15: {
                acomm = new InfoCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 16: {
                acomm = new SessioninfoCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 17: {
                acomm = new SyncHPCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 18: {
                acomm = new DeletionMarkCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 19: {
                acomm = new PackCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 22: {
                acomm = new ResetDelstatCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 20: {
                acomm = new UnpackCommand(shandle, collection, httpclient, archuser);
                break;
            }
            case 21: {
                acomm = new PackStatusCommand(shandle, collection, httpclient, archuser);
                break;
            }
            default: {
                throw new UnsupportedCommandException("Command " + command + " is not a valid archiving command");
            }
        }
        return acomm;
    }

    public static ArchCommandFactory getCommandFactory() {
        return acf;
    }
}

