/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn.commands;

import com.sap.archtech.archconn.ArchCommand;
import com.sap.archtech.archconn.ArchResponse;
import com.sap.archtech.archconn.exceptions.MethodNotApplicableException;
import com.sap.archtech.archconn.httpclients.ArchHTTPClient;
import com.sap.archtech.archconn.util.URI;
import com.sap.archtech.archconn.values.IndexPropDescription;
import com.sap.archtech.archconn.values.IndexPropValues;
import com.sap.archtech.archconn.values.SelectClause;
import com.sap.archtech.archconn.values.TechResKey;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public abstract class AbstractArchCommand
implements ArchCommand {
    protected String status;
    protected ArchResponse response;
    protected HashMap headerFields = new HashMap();
    protected ArchHTTPClient client;

    protected AbstractArchCommand(String session, String archuser) {
        this.headerFields.put("User-Agent", "SAPArchivingConnector");
        this.headerFields.put("user", archuser);
        if (session != null) {
            this.headerFields.put("ArchSession", session);
        }
    }

    public void addParam(String hfield, String value) {
        if (hfield != null && value != null) {
            this.headerFields.put(hfield, value);
        }
    }

    public void addParam(URI uri) throws MethodNotApplicableException {
        throw new MethodNotApplicableException("addParam(InputStream) is not supported for this archiving command");
    }

    public void addParam(InputStream in1) throws IOException, MethodNotApplicableException {
        throw new MethodNotApplicableException("addParam(InputStream) is not supported for this archiving command");
    }

    public void addParam(IndexPropValues ipv) throws IOException, MethodNotApplicableException {
        throw new MethodNotApplicableException("addParam(IndexPropValues) is not supported for this archiving command");
    }

    public void addParam(IndexPropDescription ipd) throws IOException, MethodNotApplicableException {
        throw new MethodNotApplicableException("addParam(IndexPropDescription) is not supported for this archiving command");
    }

    public void addParam(SelectClause slc) throws IOException, MethodNotApplicableException {
        throw new MethodNotApplicableException("addParam(SelectClause) is not supported for this archiving command");
    }

    public void addParam(TechResKey reskey) throws MethodNotApplicableException {
        throw new MethodNotApplicableException("addParam(IndexProp) is not supported for this archiving command");
    }

    public void execute() throws IOException {
        this.response = this.client.executeRequest(this.headerFields);
    }

    public ArchResponse getResponse() {
        return this.response;
    }
}

