/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn;

import com.sap.archtech.archconn.AbstractArchSession;
import com.sap.archtech.archconn.ArchCommand;
import com.sap.archtech.archconn.exceptions.ArchConfigException;
import com.sap.archtech.archconn.exceptions.SessionHandlingException;
import com.sap.archtech.archconn.exceptions.UnsupportedCommandException;
import com.sap.archtech.archconn.util.ArchConfigProviderSingle;
import com.sap.archtech.archconn.util.URI;
import com.tssap.dtr.client.lib.protocol.Connection;
import java.io.IOException;

class UnqualifiedArchSession
extends AbstractArchSession {
    UnqualifiedArchSession(String archuser, String archset) throws ArchConfigException {
        ArchConfigProviderSingle acps = ArchConfigProviderSingle.getArchConfigProviderSingle();
        this.collection = null;
        this.archdestination = acps.getArchDest();
        this.archprotocol = acps.getArchProt();
        this.clientlib = acps.getArchProtLib();
        this.archuser = archuser;
        this.archiveset = archset;
        this.archsethome = new URI(acps.getArchSetHome(this.archiveset));
        this.httpTemplate = acps.getHttpTemplate();
        this.conn = new Connection(this.httpTemplate);
        this.conn.setSocketReadTimeout(acps.getReadTimeout());
        this.conn.setSocketConnectTimeout(acps.getConnectTimeout());
        this.conn.setSocketExpirationTimeout(acps.getExpTimeout());
        try {
            this.httpclient = this.determineClientLib(acps.getArchDest(), acps.getArchProt(), acps.getArchProtLib());
        }
        catch (IOException ioex) {
            throw new ArchConfigException(ioex.getMessage());
        }
    }

    public void open() throws IOException, SessionHandlingException {
    }

    public void close() throws SessionHandlingException {
        this.conn.close();
    }

    public void cancel() throws SessionHandlingException {
        this.conn.close();
    }

    public ArchCommand createCommand(String command) throws UnsupportedCommandException, SessionHandlingException {
        ArchCommand acom = this.acf.getArchCommand(command, this.shandle, this.collection, this.httpclient, this.archuser, false);
        return acom;
    }

    public void setComment(String string) {
    }

    public String getComment() {
        return null;
    }

    public URI getAutonamecol() {
        return null;
    }

    public URI getArchsethome() {
        return this.archsethome;
    }

    public boolean isQualified() {
        return false;
    }
}

