/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn;

import com.sap.archtech.archconn.AbstractArchSession;
import com.sap.archtech.archconn.ArchCommand;
import com.sap.archtech.archconn.QualifiedArchSession;
import com.sap.archtech.archconn.commands.PutCommand;
import com.sap.archtech.archconn.exceptions.ArchConfigException;
import com.sap.archtech.archconn.exceptions.SessionHandlingException;
import com.sap.archtech.archconn.util.ArchConfigProviderSingle;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.naming.NamingException;

class TPWriteArchSession
extends QualifiedArchSession {
    private static final String INS_SESSOP_TPW = "INSERT INTO BC_XMLA_ASESSIONS(coluri, wsessionstart, sessiontype, sessionstatus, sessionuser, comment, archset, ainstance) values (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPD_SESSCL_TPW = "UPDATE BC_XMLA_ASESSIONS SET wsessionstop = ?, wcount = ?, sessionstatus = ? WHERE coluri = ?";
    private static final String UPD_COUNT_TPW = "UPDATE BC_XMLA_ASESSIONS SET wcount = ? where coluri = ?";
    private static final String SEL_BRW = "SELECT coluri FROM BC_XMLA_ASESSIONS WHERE archset = ? AND sessionstatus = 'BRW'";
    private int wcount;

    protected TPWriteArchSession(String archuser, int mode, String archiveset, String pathextension, boolean autonaming) throws ArchConfigException, SessionHandlingException {
        super(archuser, mode, archiveset, pathextension, autonaming);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void count_res(ArchCommand acom) throws SessionHandlingException {
        Connection con = null;
        PreparedStatement pst3 = null;
        if (acom instanceof PutCommand) {
            ++this.wcount;
        }
        if (this.updfrq == 0) {
            return;
        }
        if (this.wcount % this.updfrq != 0) return;
        try {
            try {
                con = this.getConnection();
                pst3 = con.prepareStatement(UPD_COUNT_TPW);
                pst3.setLong(1, this.wcount);
                pst3.setString(2, this.format(this.collection.toString()));
                int reccount = pst3.executeUpdate();
                if (reccount != 1) {
                    throw new SessionHandlingException("Cannot update counter for written documents for session " + this.collection);
                }
                con.commit();
            }
            catch (NamingException namex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.count_res()", (Throwable)namex);
                throw new SessionHandlingException("Problem persisting session info: " + namex.getMessage());
            }
            catch (SQLException sqlex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.count_res()", (Throwable)sqlex);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex.getMessage());
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            try {
                if (pst3 != null) {
                    pst3.close();
                }
                if (con == null) throw throwable;
                con.close();
                throw throwable;
            }
            catch (SQLException sqlex2) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.count_res()", (Throwable)sqlex2);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
            }
        }
        try {}
        catch (SQLException sqlex2) {
            AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.count_res()", (Throwable)sqlex2);
            throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
        }
        if (pst3 != null) {
            pst3.close();
        }
        if (con == null) return;
        con.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void open_dbaction() throws SessionHandlingException {
        Statement pst1 = null;
        Statement pst2 = null;
        Connection conn = null;
        Timestamp dateTime = new Timestamp(System.currentTimeMillis());
        ArchConfigProviderSingle acps = ArchConfigProviderSingle.getArchConfigProviderSingle();
        try {
            try {
                conn = this.getConnection();
                if (!acps.getApplRestart(this.archiveset)) {
                    pst2 = conn.prepareStatement(SEL_BRW);
                    pst2.setString(1, this.archiveset);
                    ResultSet rs2 = pst2.executeQuery();
                    if (rs2.next()) {
                        rs2.close();
                        AbstractArchSession.cat.infoT(AbstractArchSession.loc, "Broken write session for archiving set " + this.archiveset + " detected. New write session can not be opened.");
                        throw new SessionHandlingException("A broken write session for this archive set exists. Deletion is required before starting a new write session");
                    }
                    rs2.close();
                }
                pst1 = conn.prepareStatement(INS_SESSOP_TPW);
                pst1.setString(1, this.format(this.collection.toString()));
                pst1.setTimestamp(2, dateTime);
                pst1.setString(3, "T");
                pst1.setString(4, "OPW");
                pst1.setString(5, this.archuser);
                if (this.comment == null) {
                    pst1.setString(6, " ");
                } else {
                    pst1.setString(6, this.comment);
                }
                pst1.setString(7, this.archiveset);
                pst1.setString(8, System.getProperty("SAPMYNAME"));
                int reccount = pst1.executeUpdate();
                if (reccount != 1) {
                    throw new SessionHandlingException("Cannot insert archsession " + this.collection + " during session.open(). Check session name");
                }
                Object var10_9 = null;
            }
            catch (NamingException namex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.open_dbaction()", (Throwable)namex);
                throw new SessionHandlingException("Problem persisting session info: " + namex.getMessage());
            }
            catch (SQLException sqlex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.open_dbaction()", (Throwable)sqlex);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (pst1 != null) {
                    pst1.close();
                }
                if (pst2 != null) {
                    pst2.close();
                }
                if (conn == null) throw throwable;
                conn.commit();
                conn.close();
                throw throwable;
            }
            catch (SQLException sqlex2) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.open_dbaction()", (Throwable)sqlex2);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
            }
        }
        try {}
        catch (SQLException sqlex2) {
            AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.open_dbaction()", (Throwable)sqlex2);
            throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
        }
        if (pst1 != null) {
            pst1.close();
        }
        if (pst2 != null) {
            pst2.close();
        }
        if (conn == null) return;
        conn.commit();
        conn.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void close_dbaction() throws SessionHandlingException {
        Connection conn = null;
        PreparedStatement pst2 = null;
        Timestamp dateTime = new Timestamp(System.currentTimeMillis());
        try {
            try {
                conn = this.getConnection();
                pst2 = conn.prepareStatement(UPD_SESSCL_TPW);
                pst2.setTimestamp(1, dateTime);
                pst2.setLong(2, this.wcount);
                pst2.setString(3, "WRT");
                pst2.setString(4, this.format(this.collection.toString()));
                int reccount = pst2.executeUpdate();
                if (reccount != 1) {
                    throw new SessionHandlingException("Cannot update session " + this.collection + " during session.close(). Check session name");
                }
                conn.commit();
            }
            catch (NamingException namex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.close_dbaction()", (Throwable)namex);
                throw new SessionHandlingException("Problem persisting session info: " + namex.getMessage());
            }
            catch (SQLException sqlex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.close_dbaction()", (Throwable)sqlex);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex.getMessage());
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            try {
                if (pst2 != null) {
                    pst2.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException sqlex2) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.close_dbaction()", (Throwable)sqlex2);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
            }
        }
        try {}
        catch (SQLException sqlex2) {
            AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.close_dbaction()", (Throwable)sqlex2);
            throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
        }
        if (pst2 != null) {
            pst2.close();
        }
        if (conn == null) return;
        conn.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cancel_dbaction() throws SessionHandlingException {
        Connection con = null;
        PreparedStatement pst4 = null;
        Timestamp dateTime = new Timestamp(System.currentTimeMillis());
        try {
            try {
                con = this.getConnection();
                pst4 = con.prepareStatement(UPD_SESSCL_TPW);
                pst4.setTimestamp(1, dateTime);
                pst4.setLong(2, this.wcount);
                pst4.setString(3, "BRW");
                pst4.setString(4, this.format(this.collection.toString()));
                int reccount = pst4.executeUpdate();
                if (reccount != 1) {
                    throw new SessionHandlingException("Cannot update session " + this.collection + " during session.cancel(). Check session name");
                }
                con.commit();
            }
            catch (NamingException namex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.cancel_dbaction()", (Throwable)namex);
                throw new SessionHandlingException("Problem persisting session info: " + namex.getMessage());
            }
            catch (SQLException sqlex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.cancel_dbaction()", (Throwable)sqlex);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex.getMessage());
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            try {
                if (pst4 != null) {
                    pst4.close();
                }
                if (con == null) throw throwable;
                con.close();
                throw throwable;
            }
            catch (SQLException sqlex2) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.cancel_dbaction()", (Throwable)sqlex2);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
            }
        }
        try {}
        catch (SQLException sqlex2) {
            AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPWriteArchSession.cancel_dbaction()", (Throwable)sqlex2);
            throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
        }
        if (pst4 != null) {
            pst4.close();
        }
        if (con == null) return;
        con.close();
    }
}

