/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn;

import com.sap.archtech.archconn.AbstractArchSession;
import com.sap.archtech.archconn.TPDeleteArchSession;
import com.sap.archtech.archconn.exceptions.ArchConfigException;
import com.sap.archtech.archconn.exceptions.SessionHandlingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.naming.NamingException;

public class TPDeleteSimArchSession
extends TPDeleteArchSession {
    private static final String UPD_SESSCL_TPD = "UPDATE BC_XMLA_ASESSIONS SET dsessionstop = ?, dcount = ?, sessionstatus = ? WHERE coluri = ?";

    public TPDeleteSimArchSession(String archuser, int mode, String archiveset, String pathextension, boolean autonaming) throws ArchConfigException, SessionHandlingException {
        super(archuser, mode, archiveset, pathextension, autonaming);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void close_dbaction() throws SessionHandlingException {
        Connection conn = null;
        PreparedStatement pst5 = null;
        Timestamp dateTime = new Timestamp(System.currentTimeMillis());
        try {
            try {
                conn = this.getConnection();
                pst5 = conn.prepareStatement(UPD_SESSCL_TPD);
                pst5.setTimestamp(1, dateTime);
                pst5.setLong(2, --this.dcount);
                pst5.setString(3, "WRT");
                pst5.setString(4, this.format(this.collection.toString()));
                int reccount = pst5.executeUpdate();
                if (reccount != 1) {
                    throw new SessionHandlingException("Cannot update collection " + this.collection + " during session.close(). Check collection name");
                }
                conn.commit();
            }
            catch (NamingException namex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.close_dbaction()", (Throwable)namex);
                throw new SessionHandlingException("Problem persisting session info: " + namex.getMessage());
            }
            catch (SQLException sqlex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.close_dbaction()", (Throwable)sqlex);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex.getMessage());
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            try {
                if (pst5 != null) {
                    pst5.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException sqlex2) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.close_dbaction()", (Throwable)sqlex2);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
            }
        }
        try {}
        catch (SQLException sqlex2) {
            AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.close_dbaction()", (Throwable)sqlex2);
            throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
        }
        if (pst5 != null) {
            pst5.close();
        }
        if (conn == null) return;
        conn.close();
    }
}

