/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn;

import com.sap.archtech.archconn.AbstractArchSession;
import com.sap.archtech.archconn.ArchCommand;
import com.sap.archtech.archconn.ArchResponse;
import com.sap.archtech.archconn.QualifiedArchSession;
import com.sap.archtech.archconn.UnqualifiedArchSession;
import com.sap.archtech.archconn.commands.PickCommand;
import com.sap.archtech.archconn.exceptions.ArchConfigException;
import com.sap.archtech.archconn.exceptions.ArchConnException;
import com.sap.archtech.archconn.exceptions.SessionHandlingException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.naming.NamingException;

class TPDeleteArchSession
extends QualifiedArchSession {
    private static final String UPD_COUNT_TPD = "UPDATE BC_XMLA_ASESSIONS SET dcount = ? where coluri = ?";
    private static final String SEL_COL = "SELECT * FROM BC_XMLA_ASESSIONS WHERE coluri = ?";
    private static final String UPD_SESSOP_TPD = "UPDATE BC_XMLA_ASESSIONS SET dsessionstart = ?, sessionstatus = ?, ainstance = ?, deluser = ? WHERE coluri = ?";
    private static final String UPD_SESSCL_TPD = "UPDATE BC_XMLA_ASESSIONS SET dsessionstop = ?, dcount = ?, sessionstatus = ? WHERE coluri = ?";
    protected int dcount;

    protected TPDeleteArchSession(String archuser, int mode, String archiveset, String pathextension, boolean autonaming) throws ArchConfigException, SessionHandlingException {
        super(archuser, mode, archiveset, pathextension, autonaming);
    }

    public void setComment(String comment) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void count_res(ArchCommand acom) throws SessionHandlingException {
        Connection con = null;
        PreparedStatement pst1 = null;
        if (acom instanceof PickCommand) {
            ++this.dcount;
        }
        if (this.updfrq == 0) {
            return;
        }
        if (this.dcount % this.updfrq != 0) return;
        try {
            try {
                con = this.getConnection();
                pst1 = con.prepareStatement(UPD_COUNT_TPD);
                pst1.setLong(1, this.dcount);
                pst1.setString(2, this.format(this.collection.toString()));
                int reccount = pst1.executeUpdate();
                if (reccount != 1) {
                    throw new SessionHandlingException("Cannot update counter for deleted documents for session " + this.collection);
                }
                con.commit();
            }
            catch (NamingException namex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.count_res()", (Throwable)namex);
                throw new SessionHandlingException("Problem persisting session info: " + namex.getMessage());
            }
            catch (SQLException sqlex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.count_res()", (Throwable)sqlex);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex.getMessage());
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            try {
                if (pst1 != null) {
                    pst1.close();
                }
                if (con == null) throw throwable;
                con.close();
                throw throwable;
            }
            catch (SQLException sqlex2) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.count_res()", (Throwable)sqlex2);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
            }
        }
        try {}
        catch (SQLException sqlex2) {
            AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.count_res()", (Throwable)sqlex2);
            throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
        }
        if (pst1 != null) {
            pst1.close();
        }
        if (con == null) return;
        con.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void open_dbaction() throws SessionHandlingException {
        Connection conn = null;
        Statement pst2 = null;
        PreparedStatement pst3 = null;
        Timestamp dateTime = new Timestamp(System.currentTimeMillis());
        try {
            try {
                conn = this.getConnection();
                pst3 = conn.prepareStatement(SEL_COL);
                pst3.setString(1, this.format(this.collection.toString()));
                ResultSet rs3 = pst3.executeQuery();
                if (!rs3.next()) {
                    throw new SessionHandlingException("No write session corresponds to this delete session: " + this.collection);
                }
                String asstatus = rs3.getString("sessionstatus");
                if (asstatus.equals("CLS")) throw new SessionHandlingException("Write session has status " + asstatus + ". Cannot start delete session");
                if (asstatus.equals("OPW")) {
                    throw new SessionHandlingException("Write session has status " + asstatus + ". Cannot start delete session");
                }
                rs3.close();
                if (!asstatus.equals("OPD")) {
                    try {
                        UnqualifiedArchSession resetdelsession = new UnqualifiedArchSession(this.archuser, this.archiveset);
                        ArchCommand resetdelcommand = resetdelsession.createCommand("_RESET_DELSTAT");
                        resetdelcommand.addParam(this.collection);
                        resetdelcommand.execute();
                        ArchResponse resp = resetdelcommand.getResponse();
                        if (resp.getStatusCode() != 200) {
                            this.status = "cancelled";
                            AbstractArchSession.cat.errorT(AbstractArchSession.loc, "Unable to create collection, returncode is " + resp.getStatusCode() + " " + resp.getErrorMessage());
                            throw new SessionHandlingException("Unable to reset collection, returncode is " + resp.getStatusCode() + " " + resp.getErrorMessage());
                        }
                    }
                    catch (ArchConnException acex) {
                        AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.open()", (Throwable)acex);
                        this.status = "cancelled";
                        throw new SessionHandlingException("Unable to reset collection (_RESET_DELSTAT): " + acex.getMessage());
                    }
                    catch (IOException ioex) {
                        AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.open()", (Throwable)ioex);
                        this.status = "cancelled";
                        throw new SessionHandlingException("Unable to reset collection (_RESET_DELSTAT): " + ioex.getMessage());
                    }
                }
                pst2 = conn.prepareStatement(UPD_SESSOP_TPD);
                pst2.setTimestamp(1, dateTime);
                pst2.setString(2, "OPD");
                pst2.setString(3, System.getProperty("SAPMYNAME"));
                pst2.setString(4, this.archuser);
                pst2.setString(5, this.format(this.collection.toString()));
                int reccount = pst2.executeUpdate();
                if (reccount != 1) {
                    throw new SessionHandlingException("Cannot update/insert collection " + this.collection + " during session.open(). Check collection name");
                }
                conn.commit();
            }
            catch (NamingException namex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.open_dbaction()", (Throwable)namex);
                throw new SessionHandlingException("Problem persisting session info: " + namex.getMessage());
            }
            catch (SQLException sqlex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.open_dbaction()", (Throwable)sqlex);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex.getMessage());
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            try {
                if (pst2 != null) {
                    pst2.close();
                }
                if (pst3 != null) {
                    pst3.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException sqlex2) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.open_dbaction()", (Throwable)sqlex2);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
            }
        }
        try {}
        catch (SQLException sqlex2) {
            AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.open_dbaction()", (Throwable)sqlex2);
            throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
        }
        if (pst2 != null) {
            pst2.close();
        }
        if (pst3 != null) {
            pst3.close();
        }
        if (conn == null) return;
        conn.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void close_dbaction() throws SessionHandlingException {
        Connection conn = null;
        PreparedStatement pst5 = null;
        Timestamp dateTime = new Timestamp(System.currentTimeMillis());
        try {
            try {
                conn = this.getConnection();
                pst5 = conn.prepareStatement(UPD_SESSCL_TPD);
                pst5.setTimestamp(1, dateTime);
                pst5.setLong(2, --this.dcount);
                pst5.setString(3, "CLS");
                pst5.setString(4, this.format(this.collection.toString()));
                int reccount = pst5.executeUpdate();
                if (reccount != 1) {
                    throw new SessionHandlingException("Cannot update collection " + this.collection + " during session.close(). Check collection name");
                }
                conn.commit();
            }
            catch (NamingException namex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.close_dbaction()", (Throwable)namex);
                throw new SessionHandlingException("Problem persisting session info: " + namex.getMessage());
            }
            catch (SQLException sqlex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.close_dbaction()", (Throwable)sqlex);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex.getMessage());
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            try {
                if (pst5 != null) {
                    pst5.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException sqlex2) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.close_dbaction()", (Throwable)sqlex2);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
            }
        }
        try {}
        catch (SQLException sqlex2) {
            AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.close_dbaction()", (Throwable)sqlex2);
            throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
        }
        if (pst5 != null) {
            pst5.close();
        }
        if (conn == null) return;
        conn.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cancel_dbaction() throws SessionHandlingException {
        Connection con = null;
        PreparedStatement pst4 = null;
        Timestamp dateTime = new Timestamp(System.currentTimeMillis());
        AbstractArchSession.loc.infoT("Cancelling archiving session for collection " + this.collection);
        try {
            try {
                con = this.getConnection();
                pst4 = con.prepareStatement(UPD_SESSCL_TPD);
                pst4.setTimestamp(1, dateTime);
                pst4.setLong(2, this.dcount);
                pst4.setString(3, "BRD");
                pst4.setString(4, this.format(this.collection.toString()));
                int reccount = pst4.executeUpdate();
                if (reccount != 1) {
                    throw new SessionHandlingException("Cannot update session " + this.collection + " during session.cancel()");
                }
                Object var8_5 = null;
            }
            catch (NamingException namex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.cancel_dbaction()", (Throwable)namex);
                throw new SessionHandlingException("Problem persisting session info: " + namex.getMessage());
            }
            catch (SQLException sqlex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.cancel_dbaction()", (Throwable)sqlex);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            try {
                if (pst4 != null) {
                    pst4.close();
                }
                if (con == null) throw throwable;
                con.close();
                throw throwable;
            }
            catch (SQLException sqlex2) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.cancel_dbaction()", (Throwable)sqlex2);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
            }
        }
        try {}
        catch (SQLException sqlex2) {
            AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "TPDeleteArchSession.cancel_dbaction()", (Throwable)sqlex2);
            throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
        }
        if (pst4 != null) {
            pst4.close();
        }
        if (con == null) return;
        con.close();
    }
}

