/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn;

import com.sap.archtech.archconn.AbstractArchSession;
import com.sap.archtech.archconn.ArchCommand;
import com.sap.archtech.archconn.ArchResponse;
import com.sap.archtech.archconn.OPArchSession;
import com.sap.archtech.archconn.TPWriteArchSession;
import com.sap.archtech.archconn.UnqualifiedArchSession;
import com.sap.archtech.archconn.exceptions.ArchConfigException;
import com.sap.archtech.archconn.exceptions.ArchConnException;
import com.sap.archtech.archconn.exceptions.SessionHandlingException;
import com.sap.archtech.archconn.exceptions.UnsupportedCommandException;
import com.sap.archtech.archconn.util.ArchConfigProviderSingle;
import com.sap.archtech.archconn.util.URI;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

abstract class QualifiedArchSession
extends AbstractArchSession {
    private static final String JDBC_PATH = "jdbc/SAP/BC_XMLA";
    private static final String base32Chars = "abcdefghijklmnopqrstuvwxyz234567";
    protected int updfrq;
    protected String status;
    protected URI autonamecoll;
    protected String comment;

    QualifiedArchSession(String archuser, int mode, String archiveset, String pathextension, boolean autonaming) throws ArchConfigException, SessionHandlingException {
        ArchConfigProviderSingle acps = ArchConfigProviderSingle.getArchConfigProviderSingle();
        if (mode < 1 || mode > 4) {
            throw new SessionHandlingException("This mode is not allowed. Specify a supported session mode.");
        }
        if (!pathextension.endsWith("/")) {
            throw new SessionHandlingException("Path extension " + pathextension + " denotes no collection (missing \"/\" at the end)");
        }
        this.archiveset = archiveset;
        this.archuser = archuser;
        this.archdestination = acps.getArchDest();
        this.archprotocol = acps.getArchProt();
        this.clientlib = acps.getArchProtLib();
        this.updfrq = acps.getUpdFrequency();
        this.httpTemplate = acps.getHttpTemplate();
        this.conn = new com.tssap.dtr.client.lib.protocol.Connection(this.httpTemplate);
        this.conn.setSocketReadTimeout(acps.getReadTimeout());
        this.conn.setSocketConnectTimeout(acps.getConnectTimeout());
        this.conn.setSocketExpirationTimeout(acps.getExpTimeout());
        try {
            this.httpclient = this.determineClientLib(acps.getArchDest(), acps.getArchProt(), acps.getArchProtLib());
        }
        catch (IOException ioex) {
            throw new ArchConfigException(ioex.getMessage());
        }
        this.archsethome = new URI(acps.getArchSetHome(archiveset));
        if (autonaming) {
            this.autonamecoll = new URI(this.encodeBase32(this.guigen.createGUID().toHexString()).concat("/"));
            this.collection = this.archsethome.resolve(pathextension).resolve(this.autonamecoll);
        } else {
            this.collection = this.archsethome.resolve(pathextension);
        }
        if (this.collection.toString().length() > 127) {
            throw new SessionHandlingException("Collection URI exceeds size limit ( 127 characters)");
        }
        this.status = "created";
        AbstractArchSession.cat.infoT(AbstractArchSession.loc, "Created qualified archiving session for user {0}, mode {1}, archiving application {2}, target collection {3}", new Object[]{this.archuser, new Integer(mode), archiveset, this.collection});
    }

    public void open() throws IOException, SessionHandlingException {
        if (!"created".equals(this.status)) {
            throw new SessionHandlingException("Session not in status created; probably closed. Cannot open session.");
        }
        ArchCommand acommpath = null;
        ArchCommand acomhead = null;
        if (this instanceof TPWriteArchSession || this instanceof OPArchSession) {
            try {
                UnqualifiedArchSession archsess1 = new UnqualifiedArchSession(this.archuser, this.archiveset);
                acommpath = archsess1.createCommand("MODIFYPATH");
                acommpath.addParam(this.collection);
            }
            catch (ArchConnException acex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "QualifiedArchSession.open()", (Throwable)acex);
                this.status = "cancelled";
                throw new IOException("Unable to create collection: " + acex.getMessage());
            }
            acommpath.execute();
            ArchResponse resp = acommpath.getResponse();
            if (resp.getStatusCode() != 200) {
                this.status = "cancelled";
                AbstractArchSession.cat.errorT(AbstractArchSession.loc, "Unable to create collection, returncode is " + resp.getStatusCode() + " " + resp.getErrorMessage());
                throw new IOException("Unable to create collection, returncode is " + resp.getStatusCode() + " " + resp.getErrorMessage());
            }
        } else {
            try {
                UnqualifiedArchSession archsess2 = new UnqualifiedArchSession(this.archuser, this.archiveset);
                acomhead = archsess2.createCommand("HEAD");
                acomhead.addParam(this.collection);
            }
            catch (ArchConnException acex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "QualifiedArchSession.open()", (Throwable)acex);
                this.status = "cancelled";
                throw new IOException("Unable to create collection: " + acex.getMessage());
            }
            acomhead.execute();
            ArchResponse resp = acomhead.getResponse();
            if (resp.getStatusCode() != 200) {
                this.status = "cancelled";
                AbstractArchSession.cat.errorT(AbstractArchSession.loc, "Specified collection does not exist: " + resp.getStatusCode() + " " + resp.getErrorMessage());
                throw new IOException("Specified collection does not exist: " + resp.getStatusCode() + " " + resp.getErrorMessage());
            }
        }
        this.open_dbaction();
        this.status = "open";
        AbstractArchSession.cat.infoT(AbstractArchSession.loc, "Archiving session for collection {0} opened.", new Object[]{this.collection});
    }

    public void close() throws SessionHandlingException {
        this.close_dbaction();
        this.conn.close();
        this.status = "closed";
        AbstractArchSession.cat.infoT(AbstractArchSession.loc, "Archiving session for collection {0} closed.", new Object[]{this.collection});
    }

    public void cancel() throws SessionHandlingException {
        this.cancel_dbaction();
        this.conn.close();
        this.status = "cancel";
        AbstractArchSession.cat.warningT(AbstractArchSession.loc, "Archiving session for collection {0} cancelled!", new Object[]{this.collection});
    }

    public ArchCommand createCommand(String command) throws UnsupportedCommandException, SessionHandlingException {
        if (!this.status.equals("open") && !this.status.equals("unqualified")) {
            throw new SessionHandlingException("Session not open. Cannot create new archiving command.");
        }
        ArchCommand acom = this.acf.getArchCommand(command, this.shandle, this.collection, this.httpclient, this.archuser, true);
        this.count_res(acom);
        return acom;
    }

    public void setComment(String comment) throws SessionHandlingException {
        if (comment.length() > 60) {
            throw new SessionHandlingException("Session comment can only be up to 60 characters long");
        }
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public URI getAutonamecol() {
        return this.autonamecoll;
    }

    public URI getArchsethome() {
        return this.archsethome;
    }

    public boolean isQualified() {
        return true;
    }

    protected Connection getConnection() throws NamingException, SQLException {
        Connection conn = null;
        InitialContext ctx = new InitialContext();
        DataSource ds = (DataSource)ctx.lookup(JDBC_PATH);
        conn = ds.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    protected String format(String uri) {
        if (!"/".equals(uri)) {
            uri = uri.substring(0, uri.length() - 1).toLowerCase();
        }
        return uri;
    }

    protected abstract void count_res(ArchCommand var1) throws SessionHandlingException;

    protected abstract void open_dbaction() throws SessionHandlingException;

    protected abstract void close_dbaction() throws SessionHandlingException;

    protected abstract void cancel_dbaction() throws SessionHandlingException;

    private String encodeBase32(String guidhex) {
        String template = "0000";
        StringBuffer digitalguid = new StringBuffer(128);
        StringBuffer base32guid = new StringBuffer(26);
        int i = 0;
        while (i < guidhex.length()) {
            Integer guidint = Integer.valueOf(guidhex.substring(i, i + 1), 16);
            String guidbin = Integer.toString(guidint.shortValue(), 2);
            guidbin = template + guidbin;
            guidbin = guidbin.substring(guidbin.length() - template.length(), guidbin.length());
            digitalguid = digitalguid.append(guidbin);
            ++i;
        }
        int j = 0;
        while (j < 26) {
            String binpart = j == 25 ? digitalguid.substring(j * 5, j * 5 + 3) : digitalguid.substring(j * 5, j * 5 + 5);
            Integer base32index = Integer.valueOf(binpart, 2);
            base32guid.append(base32Chars.charAt(base32index));
            ++j;
        }
        return base32guid.toString();
    }
}

