/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn;

import com.sap.archtech.archconn.AbstractArchSession;
import com.sap.archtech.archconn.ArchCommand;
import com.sap.archtech.archconn.QualifiedArchSession;
import com.sap.archtech.archconn.commands.PickCommand;
import com.sap.archtech.archconn.commands.PutCommand;
import com.sap.archtech.archconn.exceptions.ArchConfigException;
import com.sap.archtech.archconn.exceptions.SessionHandlingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.naming.NamingException;

class OPArchSession
extends QualifiedArchSession {
    private static final String UPD_COUNT_OP = "UPDATE BC_XMLA_ASESSIONS SET wcount = ?, dcount = ? where coluri = ?";
    private static final String INS_SESSOP_OP = "INSERT INTO BC_XMLA_ASESSIONS(coluri, wsessionstart, dsessionstart, sessiontype, sessionstatus, sessionuser, comment, ainstance) values (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPD_SESSCL_OP = "UPDATE BC_XMLA_ASESSIONS SET wsessionstop = ?, dsessionstop = ?, wcount = ?, dcount = ?, sessionstatus = ? WHERE coluri = ?";
    private int dcount;
    private int wcount;

    protected OPArchSession(String archuser, int mode, String archiveset, String pathextension, boolean autonaming) throws ArchConfigException, SessionHandlingException {
        super(archuser, mode, archiveset, pathextension, autonaming);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void count_res(ArchCommand acom) throws SessionHandlingException {
        Connection con = null;
        PreparedStatement pst1 = null;
        if (acom instanceof PutCommand) {
            ++this.wcount;
        }
        if (acom instanceof PickCommand) {
            ++this.dcount;
        }
        if (this.updfrq == 0) {
            return;
        }
        if (this.wcount % this.updfrq != 0) return;
        try {
            try {
                con = this.getConnection();
                pst1 = con.prepareStatement(UPD_COUNT_OP);
                pst1.setLong(1, this.wcount);
                pst1.setLong(2, this.wcount);
                pst1.setString(3, this.format(this.collection.toString()));
                int reccount = pst1.executeUpdate();
                if (reccount != 1) {
                    throw new SessionHandlingException("Can not update counter for deleted/written documents for session " + this.collection);
                }
                con.commit();
            }
            catch (NamingException namex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.count_res()", (Throwable)namex);
                throw new SessionHandlingException("Problem persisting session info: " + namex.getMessage());
            }
            catch (SQLException sqlex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.count_res()", (Throwable)sqlex);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex.getMessage());
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            try {
                if (pst1 != null) {
                    pst1.close();
                }
                if (con == null) throw throwable;
                con.close();
                throw throwable;
            }
            catch (SQLException sqlex2) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.count_res()", (Throwable)sqlex2);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
            }
        }
        try {}
        catch (SQLException sqlex2) {
            AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.count_res()", (Throwable)sqlex2);
            throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
        }
        if (pst1 != null) {
            pst1.close();
        }
        if (con == null) return;
        con.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void open_dbaction() throws SessionHandlingException {
        Connection conn = null;
        PreparedStatement pst2 = null;
        Timestamp dateTime = new Timestamp(System.currentTimeMillis());
        try {
            try {
                conn = this.getConnection();
                pst2 = conn.prepareStatement(INS_SESSOP_OP);
                pst2.setString(1, this.format(this.collection.toString()));
                pst2.setTimestamp(2, dateTime);
                pst2.setTimestamp(3, dateTime);
                pst2.setString(4, "O");
                pst2.setString(5, "OPN");
                pst2.setString(6, this.archuser);
                if (this.comment == null) {
                    pst2.setString(7, " ");
                } else {
                    pst2.setString(7, this.comment);
                }
                pst2.setString(8, System.getProperty("SAPMYNAME"));
                int reccount = pst2.executeUpdate();
                if (reccount != 1) {
                    throw new SessionHandlingException("Can not update/insert archsession " + this.collection + " during session.open(). Check session name");
                }
                conn.commit();
            }
            catch (NamingException namex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.open_dbaction()", (Throwable)namex);
                throw new SessionHandlingException("Problem persisting session info: " + namex.getMessage());
            }
            catch (SQLException sqlex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.open_dbaction()", (Throwable)sqlex);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex.getMessage());
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            try {
                if (pst2 != null) {
                    pst2.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException sqlex2) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.open_dbaction()", (Throwable)sqlex2);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
            }
        }
        try {}
        catch (SQLException sqlex2) {
            AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.open_dbaction()", (Throwable)sqlex2);
            throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
        }
        if (pst2 != null) {
            pst2.close();
        }
        if (conn == null) return;
        conn.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void close_dbaction() throws SessionHandlingException {
        Connection conn = null;
        PreparedStatement pst3 = null;
        Timestamp dateTime = new Timestamp(System.currentTimeMillis());
        try {
            try {
                conn = this.getConnection();
                pst3 = conn.prepareStatement(UPD_SESSCL_OP);
                pst3.setTimestamp(1, dateTime);
                pst3.setTimestamp(2, dateTime);
                pst3.setLong(3, this.wcount);
                pst3.setLong(4, this.wcount);
                pst3.setString(5, "CLS");
                pst3.setString(6, this.format(this.collection.toString()));
                int reccount = pst3.executeUpdate();
                if (reccount != 1) {
                    throw new SessionHandlingException("Can not update collection " + this.collection + " during session.close(). Check collection name");
                }
                Object var8_5 = null;
            }
            catch (NamingException namex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.close_dbaction()", (Throwable)namex);
                throw new SessionHandlingException("Problem persisting session info: " + namex.getMessage());
            }
            catch (SQLException sqlex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.close_dbaction()", (Throwable)sqlex);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            try {
                if (pst3 != null) {
                    pst3.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException sqlex2) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.close_dbaction()", (Throwable)sqlex2);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
            }
        }
        try {}
        catch (SQLException sqlex2) {
            AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.close_dbaction()", (Throwable)sqlex2);
            throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
        }
        if (pst3 != null) {
            pst3.close();
        }
        if (conn == null) return;
        conn.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cancel_dbaction() throws SessionHandlingException {
        Connection con = null;
        PreparedStatement pst4 = null;
        Timestamp dateTime = new Timestamp(System.currentTimeMillis());
        try {
            try {
                con = this.getConnection();
                pst4 = con.prepareStatement(UPD_SESSCL_OP);
                pst4.setTimestamp(1, dateTime);
                pst4.setTimestamp(2, dateTime);
                pst4.setLong(3, this.wcount);
                pst4.setLong(4, this.wcount);
                pst4.setString(5, "BRK");
                pst4.setString(6, this.format(this.collection.toString()));
                int reccount = pst4.executeUpdate();
                if (reccount != 1) {
                    throw new SessionHandlingException("Can not update session " + this.collection + " during session.cancel(). Check collection name");
                }
                con.commit();
            }
            catch (NamingException namex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.cancel_dbaction()", (Throwable)namex);
                throw new SessionHandlingException("Problem persisting session info: " + namex.getMessage());
            }
            catch (SQLException sqlex) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.cancel_dbaction()", (Throwable)sqlex);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex.getMessage());
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            try {
                if (pst4 != null) {
                    pst4.close();
                }
                if (con == null) throw throwable;
                con.close();
                throw throwable;
            }
            catch (SQLException sqlex2) {
                AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.cancel_dbaction()", (Throwable)sqlex2);
                throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
            }
        }
        try {}
        catch (SQLException sqlex2) {
            AbstractArchSession.cat.logThrowableT(500, AbstractArchSession.loc, "OPArchSession.cancel_dbaction()", (Throwable)sqlex2);
            throw new SessionHandlingException("Problem persisting session info: " + sqlex2.getMessage());
        }
        if (pst4 != null) {
            pst4.close();
        }
        if (con == null) return;
        con.close();
    }
}

