/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn;

import com.sap.archtech.archconn.ArchResponse;
import com.sap.archtech.archconn.exceptions.UnsupportedCommandException;
import com.sap.archtech.archconn.util.DASResponseInputStream;
import com.sap.archtech.archconn.util.URI;
import com.sap.archtech.archconn.values.IndexPropDescription;
import com.sap.archtech.archconn.values.IndexPropValues;
import com.sap.archtech.archconn.values.ResourceData;
import com.sap.archtech.archconn.values.ServiceInfo;
import com.sap.archtech.archconn.values.SessionInfo;
import com.sap.archtech.archconn.values.TechResKey;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;

public class DTRHTTPArchResponse
implements ArchResponse {
    private IResponse resp;
    private String archcommand;
    private static final Location loc = Location.getLocation((String)"com.sap.archtech.archconn");
    private static final Category cat = Category.getCategory((Category)Category.APPS_COMMON_ARCHIVING, (String)"Connector");

    public DTRHTTPArchResponse(IResponse resp, String archcommand) {
        this.resp = resp;
        this.archcommand = archcommand;
    }

    public int getStatusCode() throws IOException {
        return this.resp.getStatus();
    }

    public String getProtMessage() throws IOException {
        return this.resp.getStatusDescription();
    }

    public String getServiceMessage() {
        return this.resp.getHeaderValue("service_message");
    }

    /*
     * WARNING - void declaration
     */
    public String getErrorMessage() throws IOException {
        if (this.resp.getStatus() != 200) {
            String inputLine;
            InputStream is = this.resp.getStream();
            if (is == null) {
                return "";
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String message = null;
            while ((inputLine = in.readLine()) != null) {
                void var3_4;
                message = message + (String)var3_4;
            }
            in.close();
            return message;
        }
        return "";
    }

    public InputStream getBody() throws IOException, UnsupportedCommandException {
        if ("PICK".equals(this.archcommand) && !this.resp.getHeaderValue("returntype").equals("xmldoc")) {
            throw new UnsupportedCommandException("Index specified in PICK, use getIndexProps() to read index values");
        }
        IResponseStream stresp = this.resp.getContent();
        return new DASResponseInputStream(new BufferedInputStream(stresp.asStream()));
    }

    public ArrayList getResourceData() throws IOException, UnsupportedCommandException {
        ArrayList reslist = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(new DASResponseInputStream(this.resp.getStream())));
        if (!("SELECT".equals(this.archcommand) || "LIST".equals(this.archcommand) || "HEAD".equals(this.archcommand))) {
            throw new UnsupportedCommandException("getResourceData() only allowed for LIST, SELECT and HEAD archiving commands");
        }
        if ("SELECT".equals(this.archcommand) || "LIST".equals(this.archcommand)) {
            reslist = this.parseListSelectBody(br);
        }
        if ("HEAD".equals(this.archcommand)) {
            reslist = this.parseHeadBody(br);
        }
        return reslist;
    }

    public TechResKey getResKey() throws UnsupportedCommandException {
        String key = null;
        if (!"PICK".equals(this.archcommand)) {
            throw new UnsupportedCommandException("getResKey() only allowed for PICK archiving command");
        }
        key = this.resp.getHeaderValue("reskey");
        if (key != null) {
            return new TechResKey(key);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public IndexPropDescription getIndexProps() throws IOException, UnsupportedCommandException {
        String inputLine;
        if (!"INDEXDESCRIBE".equals(this.archcommand)) {
            throw new UnsupportedCommandException("getIndexProps() only allowed for PICK archiving command");
        }
        IndexPropDescription ipd = new IndexPropDescription(this.resp.getHeaderValue("index_name"));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new DASResponseInputStream(new BufferedInputStream(this.resp.getStream())), "UTF-8"));
        while ((inputLine = br.readLine()) != null) {
            void var2_3;
            StringTokenizer tok = new StringTokenizer((String)var2_3, ":");
            String propname = tok.nextToken();
            String proptype = tok.nextToken();
            ipd.putDesc(propname, proptype);
        }
        br.close();
        return ipd;
    }

    public IndexPropValues getIndexValues() throws IOException, UnsupportedCommandException {
        IndexPropValues ipv;
        if (!"INDEXGET".equals(this.archcommand) && !"PICK".endsWith(this.archcommand)) {
            throw new UnsupportedCommandException("getIndexValues() only allowed for INDEXGET and PICK archiving command");
        }
        if ("PICK".equals(this.archcommand) && !this.resp.getHeaderValue("returntype").equals("propvalues")) {
            throw new UnsupportedCommandException("No index specified in PICK, complete resource is returned");
        }
        if (this.resp.getStatus() != 200) {
            throw new IOException("Status not OK, Index Property Values not returned");
        }
        ObjectInputStream oist = new ObjectInputStream(this.resp.getStream());
        try {
            ipv = (IndexPropValues)oist.readObject();
        }
        catch (ClassNotFoundException ccex) {
            throw new IOException(ccex.getMessage());
        }
        oist.close();
        return ipv;
    }

    public String getHeaderField(String hfield) {
        return this.resp.getHeaderValue(hfield);
    }

    public SessionInfo getSessionInfo() throws UnsupportedCommandException {
        throw new UnsupportedCommandException("getSessionInfo() only allowed for SESSIONINFO archiving command");
    }

    public ServiceInfo getServiceInfo() throws UnsupportedCommandException {
        ServiceInfo sinfo = new ServiceInfo();
        sinfo.setArchive_store(this.resp.getHeaderValue("archive_store"));
        sinfo.setDbproductname(this.resp.getHeaderValue("dbproductname"));
        sinfo.setDbproductversion(this.resp.getHeaderValue("dbproductversion"));
        sinfo.setJavavendor(this.resp.getHeaderValue("javavendor"));
        sinfo.setJavaversion(this.resp.getHeaderValue("javaversion"));
        sinfo.setJavavmname(this.resp.getHeaderValue("javavmname"));
        sinfo.setJavavmvendor(this.resp.getHeaderValue("javavmvendor"));
        sinfo.setJavavmversion(this.resp.getHeaderValue("javavmversion"));
        sinfo.setJdbcdrivername(this.resp.getHeaderValue("jdbcdrivername"));
        sinfo.setJdbcdriverversion(this.resp.getHeaderValue("jdbcdriverversion"));
        sinfo.setOsname(this.resp.getHeaderValue("osname"));
        sinfo.setOsversion(this.resp.getHeaderValue("osversion"));
        sinfo.setPhysical_path(this.resp.getHeaderValue("physical_path"));
        sinfo.setRelease(this.resp.getHeaderValue("release"));
        return sinfo;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList parseListSelectBody(BufferedReader br) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
        ArrayList<ResourceData> reslist = new ArrayList<ResourceData>();
        try {
            try {
                String inputLine;
                while ((inputLine = br.readLine()) != null) {
                    ResourceData res;
                    void var15_14;
                    StringTokenizer tok = new StringTokenizer((String)var15_14, ";");
                    String uri = tok.nextToken();
                    String type = tok.nextToken();
                    Date cdate = sdf.parse(tok.nextToken());
                    String cuser = tok.nextToken();
                    if ("COL".equalsIgnoreCase(type)) {
                        String frozen = tok.nextToken();
                        String colType = tok.nextToken();
                        res = new ResourceData(type, colType, new URI(uri.concat("/")), cdate, cuser, "Y".equals(frozen));
                    } else {
                        long length = Long.valueOf(tok.nextToken());
                        String checkStatus = tok.nextToken();
                        String isPacked = tok.nextToken();
                        res = new ResourceData(type, new URI(uri), cdate, cuser, length, checkStatus, "Y".equals(isPacked));
                    }
                    reslist.add(res);
                }
            }
            catch (ParseException psex) {
                cat.logThrowableT(500, loc, "DefaultArchResponse.parseListSelectBody", (Throwable)psex);
                throw new IOException("Error Parsing Creation Date");
            }
            Object var18_17 = null;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            br.close();
            throw throwable;
        }
        br.close();
        return reslist;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList parseHeadBody(BufferedReader br) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
        ArrayList<ResourceData> reslist = new ArrayList<ResourceData>();
        try {
            try {
                String inputLine;
                while ((inputLine = br.readLine()) != null) {
                    ResourceData res;
                    String uri;
                    void var15_14;
                    StringTokenizer tok = new StringTokenizer((String)var15_14, ";");
                    String type = tok.nextToken();
                    Date cdate = sdf.parse(tok.nextToken());
                    String cuser = tok.nextToken();
                    if ("COL".equalsIgnoreCase(type)) {
                        String frozen = tok.nextToken();
                        String colType = tok.nextToken();
                        uri = tok.nextToken();
                        res = new ResourceData(type, colType, new URI(uri.concat("/")), cdate, cuser, "Y".equals(frozen));
                    } else {
                        long length = Long.valueOf(tok.nextToken());
                        String checkStatus = tok.nextToken();
                        String isPacked = tok.nextToken();
                        int j = 0;
                        while (j < 5) {
                            tok.nextToken();
                            ++j;
                        }
                        uri = tok.nextToken();
                        res = new ResourceData(type, new URI(uri), cdate, cuser, length, checkStatus, "Y".equals(isPacked));
                    }
                    reslist.add(res);
                }
            }
            catch (ParseException psex) {
                cat.logThrowableT(500, loc, "DefaultArchResponse.parseHeadBody", (Throwable)psex);
                throw new IOException("Error Parsing Creation Date");
            }
            Object var19_18 = null;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            br.close();
            throw throwable;
        }
        br.close();
        return reslist;
    }
}

