/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn;

import com.sap.archtech.archconn.ArchSession;
import com.sap.archtech.archconn.OPArchSession;
import com.sap.archtech.archconn.TPDeleteArchSession;
import com.sap.archtech.archconn.TPDeleteSimArchSession;
import com.sap.archtech.archconn.TPWriteArchSession;
import com.sap.archtech.archconn.UnqualifiedArchSession;
import com.sap.archtech.archconn.exceptions.ArchConfigException;
import com.sap.archtech.archconn.exceptions.SessionHandlingException;
import com.sap.archtech.archconn.util.URI;

public class ArchSessionFactory {
    private static ArchSessionFactory asf = new ArchSessionFactory();

    private ArchSessionFactory() {
    }

    public static ArchSessionFactory getSessionFactory() {
        return asf;
    }

    public ArchSession getSession(String archuser, String archset) throws ArchConfigException {
        return new UnqualifiedArchSession(archuser, archset);
    }

    public ArchSession getSession(String archuser, int mode, String archiveset, URI pathextension, boolean autonaming) throws ArchConfigException, SessionHandlingException {
        switch (mode) {
            case 3: {
                return new OPArchSession(archuser, mode, archiveset, pathextension.toString(), autonaming);
            }
            case 1: {
                return new TPWriteArchSession(archuser, mode, archiveset, pathextension.toString(), autonaming);
            }
            case 2: {
                return new TPDeleteArchSession(archuser, mode, archiveset, pathextension.toString(), autonaming);
            }
            case 4: {
                return new TPDeleteSimArchSession(archuser, mode, archiveset, pathextension.toString(), autonaming);
            }
        }
        throw new SessionHandlingException("Invalid mode specified");
    }
}

