/*
 * Decompiled with CFR 0.152.
 */
package com.sap.archtech.archconn;

import com.sap.archtech.archconn.ArchCommand;
import com.sap.archtech.archconn.ArchSession;
import com.sap.archtech.archconn.commands.ArchCommandFactory;
import com.sap.archtech.archconn.exceptions.ArchConfigException;
import com.sap.archtech.archconn.exceptions.SessionHandlingException;
import com.sap.archtech.archconn.exceptions.UnsupportedCommandException;
import com.sap.archtech.archconn.httpclients.ArchHTTPClient;
import com.sap.archtech.archconn.httpclients.DTRdserviceClient;
import com.sap.archtech.archconn.httpclients.W3CdserviceClient;
import com.sap.archtech.archconn.util.ArchConfigProviderSingle;
import com.sap.archtech.archconn.util.URI;
import com.sap.guid.GUIDGeneratorFactory;
import com.sap.guid.IGUIDGenerator;
import com.sap.guid.IGUIDGeneratorFactory;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import java.io.IOException;

abstract class AbstractArchSession
implements ArchSession {
    protected static final Location loc = Location.getLocation((String)"com.sap.archtech.archconn");
    protected static final Category cat = Category.getCategory((Category)Category.APPS_COMMON_ARCHIVING, (String)"Connector");
    protected URI collection;
    protected String clientlib;
    protected String archdestination;
    protected String archprotocol;
    protected String archuser;
    protected String shandle;
    protected ArchHTTPClient httpclient;
    protected String archiveset;
    protected URI archsethome;
    protected Connection conn;
    protected ArchCommandFactory acf = ArchCommandFactory.getCommandFactory();
    protected IConnectionTemplate httpTemplate;
    protected IGUIDGeneratorFactory guidfactory = GUIDGeneratorFactory.getInstance();
    protected IGUIDGenerator guigen = this.guidfactory.createGUIDGenerator();

    AbstractArchSession() {
    }

    public abstract void open() throws IOException, SessionHandlingException;

    public abstract void close() throws SessionHandlingException;

    public abstract void cancel() throws SessionHandlingException;

    public abstract ArchCommand createCommand(String var1) throws UnsupportedCommandException, SessionHandlingException;

    public URI getCollection() {
        return this.collection;
    }

    public abstract void setComment(String var1) throws SessionHandlingException;

    public abstract String getComment();

    public abstract URI getAutonamecol();

    public String getArchdestination() {
        return this.archdestination;
    }

    public String getArchprotocol() {
        return this.archprotocol;
    }

    public String getClientlib() {
        return this.clientlib;
    }

    public abstract URI getArchsethome();

    public URI getArchsethome(String archiveset) throws ArchConfigException {
        ArchConfigProviderSingle acps = ArchConfigProviderSingle.getArchConfigProviderSingle();
        return new URI(acps.getArchSetHome(archiveset));
    }

    public abstract boolean isQualified();

    protected ArchHTTPClient determineClientLib(String destination, String protocol, String clientlib) throws IOException {
        if ("DSW3C".equalsIgnoreCase(clientlib)) {
            return new W3CdserviceClient(destination, protocol);
        }
        if ("DSDTR".equalsIgnoreCase(clientlib)) {
            return new DTRdserviceClient(this.httpTemplate, (IConnection)this.conn);
        }
        cat.errorT(loc, "Invalid Client Library " + clientlib + " specified");
        return null;
    }
}

