/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.util;

import com.sap.mw.jco.JCO;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class LogUtil {
    private Location m_location;
    public static final String VERSION = "$Id: //shared_tc/com.sap.security.core.server/630_VAL_REL/src/_compat/java/_core/com/sap/security/util/LogUtil.java#1 $ from $DateTime: 2004/03/08 16:48:25 $ ($Change: 14740 $)";
    public static final String RFC_DUMP_HEADER = "-----BEGIN REMOTE FUNCTION CALL-----";
    public static final String RFC_DUMP_FOOTER = "-----END REMOTE FUNCTION CALL-----";
    public static final String JRE_CALLSTACK_HEADER = "-----BEGIN JRE CALLSTACK-----";
    public static final String JRE_CALLSTACK_FOOTER = "-----END JRE CALLSTACK-----";
    private static final String CRLF = System.getProperty("line.separator");

    public LogUtil(Location loc, Category cat) {
        if (loc == null) {
            throw new NullPointerException("Location is null");
        }
        this.m_location = loc;
    }

    public void logFunction(JCO.Function function, String subLoc) {
        if (function != null && this.m_location.beDebug()) {
            try {
                StringWriter sw = new StringWriter();
                StringBuffer sb = sw.getBuffer();
                sb.append(CRLF).append(RFC_DUMP_HEADER).append(CRLF);
                function.writeHTML((Writer)sw);
                sb.append(CRLF).append(RFC_DUMP_FOOTER);
                this.m_location.debugT(subLoc, sb.toString());
            }
            catch (IOException ioe) {
                StringBuffer sb = new StringBuffer();
                sb.append("Logging of remote call to function ");
                sb.append(function.getName()).append(" failed.");
                sb.append(CRLF).append(ioe);
                this.m_location.warningT(subLoc, sb.toString());
            }
        }
    }

    public Throwable logException(Throwable t, String subLoc) {
        this.m_location.throwing(subLoc, t);
        this.logCatch(t, subLoc, null);
        return t;
    }

    public void logCatch(Throwable t, String subLoc, String ctxMsg) {
        if (this.m_location.bePath()) {
            StringWriter sw = new StringWriter();
            StringBuffer sb = sw.getBuffer();
            if (ctxMsg != null) {
                sb.append(ctxMsg);
            }
            sb.append(CRLF).append(JRE_CALLSTACK_HEADER).append(CRLF);
            t.printStackTrace(new PrintWriter(sw));
            sb.append(CRLF).append(JRE_CALLSTACK_FOOTER);
            this.m_location.pathT(subLoc, sb.toString());
        } else {
            this.m_location.errorT(subLoc, ctxMsg != null ? ctxMsg + ": " + String.valueOf(t) : String.valueOf(t));
        }
    }
}

