/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.wizard;

import com.sap.mw.jco.JCO;
import com.sap.security.Security;
import com.sap.security.um.wizard.WizardModel;
import com.sap.security.util.SAPBasis;
import java.util.Hashtable;
import java.util.Properties;

public class WizardController {
    private WizardController() {
    }

    public static void stopSapSecurity() {
        Security.unregisterAll();
        SAPBasis.unregisterAll();
    }

    public static void startSapSecurity(WizardModel model) throws Exception {
        Properties p = model.exportR3SecurityProperties();
        SAPBasis.init(p, model.getInstanceId());
        Security.init(p, model.getInstanceId());
    }

    public static String getActiveSapSystem() {
        JCO.Client client = null;
        SAPBasis sapbasis = null;
        String result = null;
        try {
            block7: {
                try {
                    sapbasis = SAPBasis.getSAPBasis();
                    if (sapbasis == null) break block7;
                    String accept = sapbasis.acceptsTickets() ? "1" : "0";
                    String create = sapbasis.createsTickets() ? "1" : "0";
                    String snc = sapbasis.isSncEnabled() ? "1" : "0";
                    StringBuffer sb = new StringBuffer();
                    client = sapbasis.getClient();
                    client.ping();
                    JCO.Attributes attr = client.getAttributes();
                    sb.append(attr.getSystemID());
                    sb.append(',').append(attr.getPartnerHost());
                    sb.append(',').append(attr.getClient());
                    sb.append(',').append(attr.getUser());
                    sb.append(',').append(accept);
                    sb.append(',').append(create);
                    sb.append(',').append(snc);
                    result = sb.toString();
                }
                catch (Exception e) {
                    Object var9_10 = null;
                    if (sapbasis != null && client != null) {
                        sapbasis.releaseClient(client);
                    }
                }
            }
            Object var9_9 = null;
            if (sapbasis != null && client != null) {
                sapbasis.releaseClient(client);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (sapbasis != null && client != null) {
                sapbasis.releaseClient(client);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void doAutoDetectTicket(WizardModel model) throws Exception {
        Properties p = new Properties();
        if (model.getUseLoadBalancing()) {
            ((Hashtable)p).put("jco.client.r3name", model.getR3Name());
            ((Hashtable)p).put("jco.client.mshost", model.getMsHost());
            ((Hashtable)p).put("jco.client.group", model.getGroup());
        } else {
            ((Hashtable)p).put("jco.client.ashost", model.getAsHost());
            ((Hashtable)p).put("jco.client.sysnr", model.getSysNr());
        }
        ((Hashtable)p).put("jco.client.user", model.getServiceUserName());
        if (model.getUseSnc()) {
            String snc_lib = model.getSncLib();
            if ("".equals(snc_lib)) {
                snc_lib = model.getSncLibGlobal();
            }
            ((Hashtable)p).put("jco.client.snc_mode", "1");
            ((Hashtable)p).put("jco.client.snc_myname", model.getSncMyName());
            ((Hashtable)p).put("jco.client.snc_partnername", model.getSncPartnerName());
            ((Hashtable)p).put("jco.client.snc_lib", snc_lib);
        } else {
            ((Hashtable)p).put("jco.client.passwd", model.getServiceUserPass());
        }
        ((Hashtable)p).put("jco.client.client", model.getClient());
        ((Hashtable)p).put("jco.client.getsso2", "1");
        JCO.Client client = JCO.createClient((Properties)p);
        client.connect();
        client.disconnect();
        String ticket = client.getAttributes().getSSOTicket();
        if (ticket != null && !"".equals(ticket.trim())) {
            model.setCreateTicket(true);
            ((Hashtable)p).remove("jco.client.user");
            ((Hashtable)p).remove("jco.client.passwd");
            ((Hashtable)p).remove("jco.client.getsso2");
            ((Hashtable)p).put("jco.client.mysapsso2", ticket);
            client = JCO.createClient((Properties)p);
            try {
                try {
                    client.connect();
                    model.setAcceptTicket(true);
                }
                catch (Exception e) {
                    model.setAcceptTicket(false);
                    Object var6_5 = null;
                    if (client == null) return;
                    client.disconnect();
                    return;
                }
                Object var6_4 = null;
                if (client == null) return;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (client == null) throw throwable;
                client.disconnect();
                throw throwable;
            }
        }
        model.setCreateTicket(false);
        model.setAcceptTicket(false);
        return;
        client.disconnect();
    }
}

