/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import com.sap.security.um.r3.Configuration;
import com.sap.security.um.r3.LoginCheck;
import com.sap.security.um.r3.LoginResult;
import com.sap.security.um.r3.Util;
import com.sap.security.usermanagement.AuthenticationFailedException;
import com.sap.security.usermanagement.UMRuntimeException;
import com.sap.security.usermanagement.UserLockedException;
import com.sap.security.util.SAPBasis;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

class RfcOpenLoginCheck
implements LoginCheck {
    private IRepository m_repository;
    private Properties m_logonproperties;
    private boolean m_getTicket;

    RfcOpenLoginCheck(Properties jcoLogonProperties, boolean getTicket) {
        this.m_logonproperties = this.filterProperties(jcoLogonProperties);
        this.m_getTicket = getTicket;
    }

    RfcOpenLoginCheck(Configuration configuration, boolean getTicket) {
        this.m_logonproperties = this.filterProperties(configuration.logonProperties);
        this.m_repository = configuration.repository;
        this.m_getTicket = getTicket;
    }

    public RfcOpenLoginCheck(SAPBasis sapBasis) {
        JCO.Client client = null;
        try {
            client = sapBasis.getClient();
            this.m_logonproperties = this.filterProperties(client.getProperties());
            Object var4_3 = null;
            if (client != null) {
                sapBasis.releaseClient(client);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (client != null) {
                sapBasis.releaseClient(client);
            }
            throw throwable;
        }
        this.m_getTicket = sapBasis.createsTickets();
        this.m_repository = sapBasis.getRepository();
    }

    public LoginResult checkAliasPassword(String alias, String password, String language) throws AuthenticationFailedException, UserLockedException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LoginResult checkUserPassword(String user, String password, String language) throws AuthenticationFailedException {
        String ticket = null;
        Properties logonp = new Properties();
        ((Hashtable)logonp).putAll(this.m_logonproperties);
        logonp.setProperty("jco.client.user", user);
        logonp.setProperty("jco.client.passwd", password);
        if (this.m_getTicket) {
            logonp.setProperty("jco.client.getsso2", "1");
        }
        if (language != null) {
            logonp.setProperty("jco.client.lang", language);
        }
        JCO.Client client = JCO.createClient((Properties)logonp);
        try {
            try {
                client.connect();
                if (this.m_getTicket && (ticket = client.getAttributes().getSSOTicket()) == null) {
                    throw new UMRuntimeException("No SAP Logon Ticket received");
                }
                Object var9_7 = null;
                if (client == null) return new LoginResult(user, ticket);
            }
            catch (JCO.Exception je) {
                this.handleException(je);
                Object var9_8 = null;
                if (client == null) return new LoginResult(user, ticket);
                client.disconnect();
                return new LoginResult(user, ticket);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (client == null) throw throwable;
            client.disconnect();
            throw throwable;
        }
        client.disconnect();
        return new LoginResult(user, ticket);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LoginResult checkUserCertificate(String user, String b64certificate, String language) throws AuthenticationFailedException {
        String ticket = null;
        Properties logonp = new Properties();
        ((Hashtable)logonp).putAll(this.m_logonproperties);
        if (user != null) {
            logonp.setProperty("jco.client.user", user);
        }
        logonp.setProperty("jco.client.x509cert", Util.stripUnwantedChars(b64certificate));
        if (this.m_getTicket) {
            logonp.setProperty("jco.client.getsso2", "1");
        }
        if (language != null) {
            logonp.setProperty("jco.client.lang", language);
        }
        JCO.Client client = JCO.createClient((Properties)logonp);
        try {
            block8: {
                try {
                    client.connect();
                    if (this.m_getTicket && (ticket = client.getAttributes().getSSOTicket()) == null) {
                        throw new UMRuntimeException("No SAP Logon Ticket received");
                    }
                    if (user != null) break block8;
                    user = this.execUserNameGet(client);
                }
                catch (JCO.Exception je) {
                    this.handleException(je);
                    Object var9_8 = null;
                    if (client == null) return new LoginResult(user, ticket);
                    client.disconnect();
                    return new LoginResult(user, ticket);
                }
            }
            Object var9_7 = null;
            if (client == null) return new LoginResult(user, ticket);
            client.disconnect();
            return new LoginResult(user, ticket);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (client == null) throw throwable;
            client.disconnect();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LoginResult checkTicket(String b64ticket) throws AuthenticationFailedException {
        String user = null;
        Properties logonp = new Properties();
        ((Hashtable)logonp).putAll(this.m_logonproperties);
        b64ticket = Util.stripUnwantedChars(b64ticket);
        b64ticket = Util.undoReplaceChar(b64ticket);
        logonp.setProperty("jco.client.mysapsso2", b64ticket);
        JCO.Client client = JCO.createClient((Properties)logonp);
        try {
            try {
                client.connect();
                user = this.execUserNameGet(client);
            }
            catch (JCO.Exception je) {
                this.handleException(je);
                Object var7_6 = null;
                if (client == null) return new LoginResult(user, null);
                client.disconnect();
                return new LoginResult(user, null);
            }
            Object var7_5 = null;
            if (client == null) return new LoginResult(user, null);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (client == null) throw throwable;
            client.disconnect();
            throw throwable;
        }
        client.disconnect();
        return new LoginResult(user, null);
    }

    protected void handleException(JCO.Exception je) throws AuthenticationFailedException {
        if (je.getGroup() == 103) {
            throw new AuthenticationFailedException(je.getMessage());
        }
        throw new UMRuntimeException(je, je.getMessage());
    }

    private Properties filterProperties(Properties src) {
        Iterator iter = ((Hashtable)src).keySet().iterator();
        Properties dest = new Properties();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if ((key = key.toLowerCase().trim()).endsWith("user") || key.endsWith("passwd") || key.endsWith("mysapsso2") || key.endsWith("x509cert") || key.endsWith("extiddata") || key.endsWith("extidtype") || key.endsWith("getsso2")) continue;
            dest.setProperty(key, src.getProperty(key));
        }
        return dest;
    }

    private String execUserNameGet(JCO.Client client) {
        if (this.m_repository == null) {
            this.m_repository = JCO.createRepository((String)("RfcOpenLoginCheck[" + new Date() + "]"), (JCO.Client)client);
        }
        JCO.Function userNameGet = this.m_repository.getFunctionTemplate("USER_NAME_GET").getFunction();
        try {
            client.execute(userNameGet);
        }
        catch (JCO.Exception je) {
            throw new UMRuntimeException(je, "while trying to execute USER_NAME_GET");
        }
        return userNameGet.getExportParameterList().getString("USER_NAME").trim();
    }
}

