/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import java.io.Serializable;

class ModifyTracker
implements Serializable {
    protected Object m_currentValue;
    protected Object m_initialValue;
    protected Object m_defaultValue;

    public ModifyTracker(Object initialValue) {
        this.m_initialValue = initialValue;
        this.m_currentValue = initialValue;
    }

    public ModifyTracker(Object initialValue, Object defaultValue) {
        this.m_initialValue = initialValue;
        this.m_currentValue = initialValue;
        this.m_defaultValue = defaultValue;
    }

    public boolean setValue(Object value) {
        Object currentValue = this.m_currentValue;
        boolean differentFromCurrent = false;
        if (currentValue != null) {
            differentFromCurrent = !currentValue.equals(value);
        } else if (value != null) {
            differentFromCurrent = true;
        }
        this.m_currentValue = value;
        return differentFromCurrent;
    }

    public Object getValue() {
        Object currentValue = this.m_currentValue;
        if (currentValue != null) {
            return currentValue;
        }
        return this.m_defaultValue;
    }

    public boolean isModified() {
        Object initialValue = this.m_initialValue;
        Object currentValue = this.m_currentValue;
        if (initialValue != null) {
            return !initialValue.equals(currentValue);
        }
        return currentValue != null;
    }

    public int hashCode() {
        Object currentValue = this.m_currentValue;
        if (currentValue != null) {
            return currentValue.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        Object currentValue = this.m_currentValue;
        Object defaultValue = this.m_defaultValue;
        if (currentValue != null) {
            return currentValue.toString();
        }
        if (defaultValue != null) {
            return defaultValue.toString();
        }
        return null;
    }

    public void rollback() {
        this.m_currentValue = this.m_initialValue;
    }

    public void reset(Object initialValue) {
        this.m_initialValue = initialValue;
        this.m_currentValue = initialValue;
    }
}

