/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import com.sap.security.um.r3.TimeZoneStrategy;
import com.sap.security.usermanagement.UMException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;

class MappingTimeZoneStrategy
implements TimeZoneStrategy {
    String[][] m_timeZoneTable;
    private static final int SAP_TZID = 0;
    private static final int JAVA_TZID = 1;
    private String m_description;

    public MappingTimeZoneStrategy(Properties timeZoneMap) {
        StringBuffer description = new StringBuffer();
        description.append(this.getClass().getName() + ": " + timeZoneMap);
        this.m_description = description.toString();
        this.m_timeZoneTable = new String[2][((Hashtable)timeZoneMap).size()];
        Set entrySet = ((Hashtable)timeZoneMap).entrySet();
        Iterator iter = entrySet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.m_timeZoneTable[1][i] = (String)entry.getKey();
            this.m_timeZoneTable[0][i] = (String)entry.getValue();
            ++i;
        }
    }

    public String getSAPTimeZone(TimeZone timeZone) throws UMException {
        if (timeZone != null) {
            int i = 0;
            while (i < this.m_timeZoneTable[1].length) {
                if (this.m_timeZoneTable[1][i].equals(timeZone.getID())) {
                    return this.m_timeZoneTable[0][i];
                }
                ++i;
            }
            throw new UMException("No mapping has been defined for the Java time zone \"" + timeZone.getID() + "\"");
        }
        return "";
    }

    public TimeZone getJavaTimeZone(String timeZone) {
        if (timeZone != null) {
            int i = 0;
            while (i < this.m_timeZoneTable[0].length) {
                if (this.m_timeZoneTable[0][i].equals(timeZone)) {
                    return TimeZone.getTimeZone(this.m_timeZoneTable[1][i]);
                }
                ++i;
            }
        }
        return null;
    }

    public String toString() {
        return this.m_description;
    }
}

