/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import com.sap.security.um.r3.TimeZoneStrategy;
import com.sap.security.usermanagement.UMException;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;

class HelpValuesTimeZoneStrategy
implements TimeZoneStrategy {
    private Set m_sapTimeZoneIDs;

    public HelpValuesTimeZoneStrategy(JCO.Client client, IRepository repository) throws UMException {
        try {
            JCO.Function helpValuesGet = repository.getFunctionTemplate("BAPI_HELPVALUES_GET").getFunction();
            JCO.ParameterList imports = helpValuesGet.getImportParameterList();
            imports.setValue("USER", "OBJNAME");
            imports.setValue("GetDetail", "METHOD");
            imports.setValue("Address", "PARAMETER");
            imports.setValue("TIME_ZONE", "FIELD");
            client.execute(helpValuesGet);
            JCO.Table valuesForField = helpValuesGet.getTableParameterList().getTable("VALUES_FOR_FIELD");
            valuesForField.firstRow();
            this.m_sapTimeZoneIDs = new HashSet();
            do {
                this.m_sapTimeZoneIDs.add(valuesForField.getString(0).trim());
            } while (valuesForField.nextRow());
        }
        catch (JCO.Exception je) {
            throw new UMException("while trying to retrieve time zone help values via BAPI_HELPVALUES_GET:\n" + je.getMessage());
        }
    }

    public String getSAPTimeZone(TimeZone timeZone) throws UMException {
        if (timeZone != null && this.m_sapTimeZoneIDs.contains(timeZone.getID())) {
            return timeZone.getID();
        }
        throw new UMException("The time zone ID \"" + timeZone.getID() + "\" is not supported by the SAP system");
    }

    public TimeZone getJavaTimeZone(String timeZone) {
        return TimeZone.getTimeZone(timeZone);
    }
}

