/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import com.sap.security.toolkit.ds.MostRecentlyUsedCache;
import com.sap.security.um.r3.ExceptionLogger;
import com.sap.security.usermanagement.UMRuntimeException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

class AuthenticationFactory {
    private static final String CACHE_SIZE = "usercache.size";
    private static final int defCacheSize = 1000;
    private static int m_cacheSize;
    private static MostRecentlyUsedCache m_cache;
    private static Properties m_properties;
    private static final Location m_location;
    private static final Category m_category;
    private static final ExceptionLogger m_exlog;
    private static final int m_severity = 300;
    static /* synthetic */ Class class$com$sap$security$um$r3$AuthenticationFactory;

    AuthenticationFactory() {
    }

    static MostRecentlyUsedCache getCache() {
        String method = "getCache()";
        m_location.entering(method);
        if (m_cache == null) {
            m_cache = new MostRecentlyUsedCache(m_cacheSize);
            m_category.logT(300, m_location, "New cache of size: " + m_cacheSize + " has been created.");
        }
        m_location.exiting(method);
        return m_cache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        m_location = Location.getLocation((Class)(class$com$sap$security$um$r3$AuthenticationFactory == null ? (class$com$sap$security$um$r3$AuthenticationFactory = AuthenticationFactory.class$("com.sap.security.um.r3.AuthenticationFactory")) : class$com$sap$security$um$r3$AuthenticationFactory));
        m_category = Category.getCategory((String)"/Security/Authentication");
        m_exlog = new ExceptionLogger(m_location, m_category, 400);
        String filename = System.getProperty("security");
        String message = null;
        if (filename == null || filename.equals("")) {
            message = ">>>>>>>>>>>>>> System property \"security\" is not set <<<<<<<<<<<<<<\n(it should contain path and filename of the security properties file)\nTrying default (\"security.properties\" in current working directory)\n";
            m_category.warningT(m_location, message);
            filename = "security.properties";
        } else {
            message = "System property \"security\" is set to: " + filename;
            m_category.infoT(m_location, message);
        }
        m_properties = new Properties();
        File file = new File(filename);
        if (file.exists()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                m_properties.load(fis);
                fis.close();
                m_category.logT(300, m_location, "Loaded configuration file for Authentication Factory from: " + filename);
                if (m_properties.getProperty(CACHE_SIZE) != null && !m_properties.getProperty(CACHE_SIZE).equals("")) {
                    try {
                        m_cacheSize = Integer.parseInt(m_properties.getProperty(CACHE_SIZE));
                    }
                    catch (NumberFormatException e) {
                        throw (UMRuntimeException)m_exlog.logException((Throwable)new UMRuntimeException("Error during initialization: property usercache.size has to be an integer."), 500);
                    }
                } else {
                    message = "No cache size configured. Setting cache size to default value 1000.";
                }
                m_category.warningT(m_location, message);
                m_cacheSize = 1000;
            }
            catch (IOException ioe) {
                throw (UMRuntimeException)m_exlog.logException((Throwable)new UMRuntimeException(ioe, "Loading of configuration file " + filename + " FAILED."), 500);
            }
        } else {
            message = ">>>>>>>>> No security properties file found <<<<<<<<\nSetting cache size to default value 1000.";
            m_category.warningT(m_location, message);
            m_cacheSize = 1000;
        }
    }
}

