/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.tools;

import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.TraceFormatter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class WizardModelXML {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$tools$WizardModelXML == null ? (class$com$sap$security$tools$WizardModelXML = WizardModelXML.class$("com.sap.security.tools.WizardModelXML")) : class$com$sap$security$tools$WizardModelXML));
    private static final String LS = System.getProperty("line.separator");
    private static final String MSG_ENTERING = "Entering method";
    private static final String MSG_EXITING = "Exiting method";
    public static final int RC_OK = 0;
    public static final int RC_INVALID_ARGS = 1;
    public static final int RC_FILE_ERROR = 2;
    public static final int RC_UNKNOWN_ERROR = 99;
    private Properties _defaultProps = new Properties();
    private Properties _umProps = new Properties();
    private Properties _connectProps = new Properties();
    private String _persistency = null;
    private String _action = null;
    private int _severity = 300;
    private boolean _loadBalancing = false;
    private DocumentBuilderFactory factory = null;
    private DocumentBuilder documentBuilder = null;
    static /* synthetic */ Class class$com$sap$security$tools$WizardModelXML;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WizardModelXML(String[] args) {
        String method = "WizardModelXML(String[] args)";
        LOCATION.pathT("WizardModelXML(String[] args)", MSG_ENTERING);
        int i = 0;
        while (i < args.length) {
            block34: {
                block37: {
                    block36: {
                        String value;
                        String key;
                        String arg;
                        int idx;
                        block35: {
                            if (!"-u".equals(args[i])) break block35;
                            if (-1 == (idx = (arg = args[++i]).indexOf(61))) {
                                LOCATION.errorT("Invalid UM property: " + arg + " Required: KEY=VALUE");
                                throw new IllegalArgumentException("Invalid UM property: " + arg + " Required: KEY=VALUE");
                            }
                            key = arg.substring(0, idx).toUpperCase();
                            if (idx >= arg.length() - 1) {
                                LOCATION.errorT("Invalid UM property: " + arg + ". Value must not be empty");
                                throw new IllegalArgumentException("Invalid UM property: " + arg + ". Value must not be empty");
                            }
                            value = arg.substring(idx + 1);
                            this._umProps.setProperty(key, value);
                            if (key.equals("ADMIN_PWD") || key.equalsIgnoreCase("GUEST_PWD")) {
                                LOCATION.infoT("WizardModelXML(String[] args)", "Added UM property: " + key + "=********");
                                break block34;
                            } else {
                                LOCATION.infoT("WizardModelXML(String[] args)", "Added UM property: " + key + "=" + value);
                            }
                            break block34;
                        }
                        if (!"-c".equals(args[i])) break block36;
                        if (-1 == (idx = (arg = args[++i]).indexOf(61))) {
                            LOCATION.errorT("Invalid connect property: " + arg + " Required: KEY=VALUE");
                            throw new IllegalArgumentException("Invalid connect property: " + arg + " Required: KEY=VALUE");
                        }
                        key = arg.substring(0, idx).toUpperCase();
                        value = idx < arg.length() - 1 ? arg.substring(idx + 1) : "";
                        this._connectProps.setProperty(key, value);
                        if (key.equals("COM_PWD")) {
                            LOCATION.infoT("WizardModelXML(String[] args)", "Added connect property: " + key + "=********");
                            break block34;
                        } else {
                            LOCATION.infoT("WizardModelXML(String[] args)", "Added connect property: " + key + "=" + value);
                        }
                        break block34;
                    }
                    if (!"-p".equals(args[i])) break block37;
                    this._persistency = args[++i];
                    if (this._persistency.equalsIgnoreCase("db")) {
                        LOCATION.infoT("Configuring UME for DB persistency");
                        break block34;
                    } else if (this._persistency.equalsIgnoreCase("abap")) {
                        LOCATION.infoT("Configuring UME for ABAP persistency");
                        break block34;
                    } else {
                        if (!this._persistency.equalsIgnoreCase("abap_db")) {
                            LOCATION.errorT("Persistency option " + this._persistency + " is not supported");
                            throw new IllegalArgumentException("Persistency option " + this._persistency + " is not supported");
                        }
                        LOCATION.infoT("Configuring UME for mixed ABAP/DB persistency");
                    }
                    break block34;
                }
                if ("-a".equals(args[i])) {
                    ++i;
                } else if (!"-h".equals(args[i])) {
                    if (!"-f".equals(args[i])) {
                        LOCATION.errorT("WizardModelXML(String[] args)", "Unexpected argument: " + args[i]);
                        throw new IllegalArgumentException("Unexpected argument: " + args[i]);
                    }
                    ++i;
                }
            }
            ++i;
        }
        if (!((Hashtable)this._umProps).containsKey("ADMIN_USR")) {
            LOCATION.errorT("WizardModelXML(String[] args)", "Missing UM property: KEY=ADMIN_USR");
            throw new IllegalArgumentException("Missing UM property: KEY=ADMIN_USR");
        }
        if (!((Hashtable)this._umProps).containsKey("GUEST_USR")) {
            LOCATION.errorT("WizardModelXML(String[] args)", "Missing UM property: KEY=GUEST_USR");
            throw new IllegalArgumentException("Missing UM property: KEY=GUEST_USR");
        }
        if (!((Hashtable)this._umProps).containsKey("ADMIN_PWD")) {
            LOCATION.errorT("WizardModelXML(String[] args)", "Missing UM property: KEY=ADMIN_PWD");
            throw new IllegalArgumentException("Missing UM property: KEY=ADMIN_PWD");
        }
        if (!((Hashtable)this._umProps).containsKey("GUEST_PWD")) {
            LOCATION.errorT("WizardModelXML(String[] args)", "Missing UM property: KEY=GUEST_PWD");
            throw new IllegalArgumentException("Missing UM property: KEY=GUEST_PWD");
        }
        if (!((Hashtable)this._umProps).containsKey("ADMIN_GRP")) {
            LOCATION.errorT("WizardModelXML(String[] args)", "Missing UM property: KEY=ADMIN_GRP");
            throw new IllegalArgumentException("Missing UM property: KEY=ADMIN_GRP");
        }
        if (!((Hashtable)this._umProps).containsKey("GUEST_GRP")) {
            LOCATION.errorT("WizardModelXML(String[] args)", "Missing UM property: KEY=GUEST_GRP");
            throw new IllegalArgumentException("Missing UM property: KEY=GUEST_GRP");
        }
        if (!((Hashtable)this._umProps).containsKey("ALL_GRP")) {
            LOCATION.errorT("WizardModelXML(String[] args)", "Missing UM property: KEY=ALL_GRP");
            throw new IllegalArgumentException("Missing UM property: KEY=ALL_GRP");
        }
        if (this._persistency.equalsIgnoreCase("abap") || this._persistency.equalsIgnoreCase("abap_db")) {
            if (((Hashtable)this._connectProps).containsKey("ASHOST") && ((Hashtable)this._connectProps).containsKey("SYSNR")) {
                this._loadBalancing = false;
            } else if (((Hashtable)this._connectProps).containsKey("MSHOST") && ((Hashtable)this._connectProps).containsKey("MSSERV") && ((Hashtable)this._connectProps).containsKey("GROUP") && ((Hashtable)this._connectProps).containsKey("R3NAME")) {
                this._loadBalancing = true;
            } else {
                throw new IllegalArgumentException("Missing connect property");
            }
            if (!((Hashtable)this._connectProps).containsKey("CLIENT")) {
                LOCATION.errorT("WizardModelXML(String[] args)", "Missing connect property: KEY=CLIENT");
                throw new IllegalArgumentException("Missing connect property: KEY=CLIENT");
            }
            if (!((Hashtable)this._connectProps).containsKey("COM_USR")) {
                LOCATION.errorT("WizardModelXML(String[] args)", "Missing connect property: KEY=COM_USR");
                throw new IllegalArgumentException("Missing connect property: KEY=COM_USR");
            }
            if (!((Hashtable)this._connectProps).containsKey("COM_PWD")) {
                LOCATION.errorT("WizardModelXML(String[] args)", "Missing connect property: KEY=COM_PWD");
                throw new IllegalArgumentException("Missing connect property: KEY=COM_PWD");
            }
        }
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
        this.factory.setValidating(false);
        try {
            this.documentBuilder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.setDefaultProps();
        LOCATION.pathT("WizardModelXML(String[] args)", MSG_EXITING);
    }

    private byte[] convertToByteArray(Node root) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(outputStream);
        DOMSource source = new DOMSource(root);
        Transformer tr = null;
        try {
            tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("omit-xml-declaration", "no");
            tr.setOutputProperty("standalone", "yes");
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("encoding", "UTF-8");
            tr.transform(source, streamResult);
            outputStream.close();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputStream.toByteArray();
    }

    public byte[] generateUserstoreXML() throws IOException {
        String method = "generateUserstoreXML()";
        LOCATION.pathT("generateUserstoreXML()", MSG_ENTERING);
        Document doc = this.documentBuilder.newDocument();
        Element root = doc.createElement("user-store-configuration");
        UserStoreConfig storeDBMS = new UserStoreConfig("userstore.xml");
        storeDBMS.addActivityStatus(false);
        storeDBMS.addDisplayName("DBMS User Store");
        storeDBMS.addDescription("User Store that uses dbms");
        storeDBMS.addUserClassName("com.sap.engine.services.userstore.UserContextImpl");
        storeDBMS.addGroupClassName("com.sap.engine.services.userstore.GroupContextImpl");
        storeDBMS.addAnonymous(this._defaultProps.getProperty("GUEST_USR"));
        storeDBMS.addGenericConfig("RETRIEVE_PASSWORDS", "false");
        storeDBMS.addGenericConfig("LOCK_AFTER_INVALID_ATTEMPTS", "5");
        storeDBMS.addGroup(this._defaultProps.getProperty("ADMIN_GRP"), new String[0], false);
        storeDBMS.addGroup(this._defaultProps.getProperty("GUEST_GRP"), new String[0], false);
        storeDBMS.addUser(this._defaultProps.getProperty("ADMIN_USR"), this._defaultProps.getProperty("ADMIN_PWD"), new String[]{this._defaultProps.getProperty("ADMIN_GRP")}, false, false);
        storeDBMS.addUser(this._defaultProps.getProperty("GUEST_USR"), this._defaultProps.getProperty("GUEST_PWD"), new String[]{this._defaultProps.getProperty("GUEST_GRP")}, true, false);
        Node nodeDBMS = doc.importNode(storeDBMS.getNodes(), true);
        root.appendChild(nodeDBMS);
        UserStoreConfig storeUME = new UserStoreConfig("userstore.xml");
        storeUME.addActivityStatus(true);
        storeUME.addDisplayName("UME User Store");
        storeUME.addDescription("User Store that uses UME");
        storeUME.addUserClassName("com.sap.security.core.server.userstore.UserContextUME");
        storeUME.addGroupClassName("com.sap.security.core.server.userstore.GroupContextUME");
        storeUME.addAnonymous(this._umProps.getProperty("GUEST_USR"));
        Node nodeUME = doc.importNode(storeUME.getNodes(), true);
        root.appendChild(nodeUME);
        LOCATION.pathT("generateUserstoreXML()", MSG_EXITING);
        return this.convertToByteArray(root);
    }

    public Properties generateUMEProps() {
        String method = "getUMEProps()";
        LOCATION.pathT("getUMEProps()", MSG_ENTERING);
        Properties umeProps = new Properties();
        umeProps.setProperty("ume.authenticationFactory", "com.sap.security.core.logon.imp.SAPJ2EEAuthenticator");
        umeProps.setProperty("ume.logonAuthenticationFactory", "com.sap.security.core.logon.imp.SAPJ2EEAuthenticator");
        umeProps.setProperty("ume.login.context", "ticket");
        umeProps.setProperty("ume.login.context.default", "ticket");
        umeProps.setProperty("login.ticket_keyalias", "SAPLogonTicketKeypair");
        umeProps.setProperty("login.ticket_keystore", "TicketKeystore");
        umeProps.setProperty("login.ticket_lifetime", "8");
        umeProps.setProperty("ume.login.guest_user.uniqueids", this._umProps.getProperty("GUEST_USR"));
        if (this._persistency.equalsIgnoreCase("db")) {
            umeProps.setProperty("ume.persistence.data_source_configuration", "dataSourceConfiguration_database_only.xml");
        } else if (this._persistency.equalsIgnoreCase("abap") || this._persistency.equalsIgnoreCase("abap_db")) {
            if (this._persistency.equalsIgnoreCase("abap")) {
                umeProps.setProperty("ume.persistence.data_source_configuration", "dataSourceConfiguration_r3_roles_db.xml");
            } else if (this._persistency.equalsIgnoreCase("abap_db")) {
                umeProps.setProperty("ume.persistence.data_source_configuration", "dataSourceConfiguration_r3_rw.xml");
            }
            umeProps.setProperty("ume.r3.connection.master.client", this._connectProps.getProperty("CLIENT"));
            umeProps.setProperty("ume.r3.connection.master.user", this._connectProps.getProperty("COM_USR"));
            umeProps.setProperty("ume.r3.connection.master.passwd", this._connectProps.getProperty("COM_PWD"));
            if (this._loadBalancing) {
                umeProps.setProperty("ume.r3.connection.master.msghost", this._connectProps.getProperty("MSHOST"));
                umeProps.setProperty("ume.r3.connection.master.msserv", this._connectProps.getProperty("MSSERV"));
                umeProps.setProperty("ume.r3.connection.master.group", this._connectProps.getProperty("GROUP"));
                umeProps.setProperty("ume.r3.connection.master.r3name", this._connectProps.getProperty("R3NAME"));
            } else {
                umeProps.setProperty("ume.r3.connection.master.ashost", this._connectProps.getProperty("ASHOST"));
                umeProps.setProperty("ume.r3.connection.master.sysnr", this._connectProps.getProperty("SYSNR"));
            }
        }
        LOCATION.pathT("getUMEProps()", MSG_EXITING);
        return umeProps;
    }

    public String getPropertyUM(String key) {
        return this._umProps.getProperty(key);
    }

    public String getPropertyConnect(String key) {
        return this._connectProps.getProperty(key);
    }

    public String getPersistency() {
        return this._persistency;
    }

    public boolean getLoadBalacing() {
        return this._loadBalancing;
    }

    public byte[] generatePolicyXML() throws IOException {
        String method = "generatePolicyXML()";
        LOCATION.pathT("generatePolicyXML()", MSG_ENTERING);
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
        this.factory.setValidating(false);
        try {
            this.documentBuilder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document doc = this.documentBuilder.newDocument();
        Element root = doc.createElement("policy-configuration");
        Policy policyDBMS = new Policy("policy.xml");
        policyDBMS.addUserStoreName("DBMS User Store");
        policyDBMS.addConfigurationTicket(false);
        policyDBMS.addConfigurationJ2EE(this._defaultProps.getProperty("ADMIN_GRP"), this._defaultProps.getProperty("GUEST_GRP"), this._defaultProps.getProperty("ALL_GRP"));
        policyDBMS.addConfigurationNaming(this._defaultProps.getProperty("ADMIN_GRP"), this._defaultProps.getProperty("ALL_GRP"));
        policyDBMS.addConfigurationTelnet(this._defaultProps.getProperty("ADMIN_GRP"));
        Node nodeDBMS = doc.importNode(policyDBMS.getNodes(), true);
        root.appendChild(nodeDBMS);
        Policy policyUME = new Policy("policy.xml");
        policyUME.addUserStoreName("UME User Store");
        policyUME.addConfigurationTicket(true);
        policyUME.addConfigurationJ2EE(this._umProps.getProperty("ADMIN_GRP"), this._umProps.getProperty("GUEST_GRP"), this._umProps.getProperty("ALL_GRP"));
        policyUME.addConfigurationNaming(this._umProps.getProperty("ADMIN_GRP"), this._umProps.getProperty("ALL_GRP"));
        policyUME.addConfigurationTelnet(this._umProps.getProperty("ADMIN_GRP"));
        Node nodeUME = doc.importNode(policyUME.getNodes(), true);
        root.appendChild(nodeUME);
        LOCATION.pathT("generatePolicyXML()", MSG_EXITING);
        return this.convertToByteArray(root);
    }

    private void configureLog() {
        int severity = 300;
        String s = System.getProperty("UMConfigurator.debug");
        if (null != s) {
            try {
                severity = Severity.parse((String)s);
            }
            catch (IllegalArgumentException iae) {
                severity = 300;
            }
        }
        ConsoleLog log = new ConsoleLog((Formatter)new TraceFormatter("%m"));
        log.setEffectiveSeverity(0);
        LOCATION.setEffectiveSeverity(severity);
        LOCATION.addLog((Log)log);
        log = new FileLog("dev_umconfigurator", (Formatter)new TraceFormatter("%24d %-13l %s: %m"));
        log.setEffectiveSeverity(0);
        LOCATION.setEffectiveSeverity(severity);
        LOCATION.addLog((Log)log);
    }

    private void setDefaultProps() {
        String method = "setDefaultProps()";
        LOCATION.pathT("setDefaultProps()", MSG_ENTERING);
        this._defaultProps.setProperty("ADMIN_USR", "Administrator");
        this._defaultProps.setProperty("GUEST_USR", "Guest");
        this._defaultProps.setProperty("ADMIN_PWD", this._umProps.getProperty("ADMIN_PWD"));
        this._defaultProps.setProperty("GUEST_PWD", this._umProps.getProperty("GUEST_PWD"));
        this._defaultProps.setProperty("ADMIN_GRP", "administrators");
        this._defaultProps.setProperty("GUEST_GRP", "guests");
        this._defaultProps.setProperty("ALL_GRP", "all");
        LOCATION.pathT("setDefaultProps()", MSG_EXITING);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UserStoreConfig {
        private Document doc = null;
        private Element root = null;
        private int usrGrpCount = 1;
        static /* synthetic */ Class class$com$sap$security$tools$WizardModelXML;

        UserStoreConfig(String template) {
            WizardModelXML.this.factory = DocumentBuilderFactory.newInstance();
            WizardModelXML.this.factory.setNamespaceAware(true);
            WizardModelXML.this.factory.setValidating(false);
            try {
                WizardModelXML.this.documentBuilder = WizardModelXML.this.factory.newDocumentBuilder();
                this.doc = WizardModelXML.this.documentBuilder.parse((class$com$sap$security$tools$WizardModelXML == null ? (class$com$sap$security$tools$WizardModelXML = UserStoreConfig.class$("com.sap.security.tools.WizardModelXML")) : class$com$sap$security$tools$WizardModelXML).getResourceAsStream(template));
                Node dummy = this.doc.getFirstChild();
                while (dummy.getNodeType() != 1 || !dummy.getNodeName().equalsIgnoreCase("user-store")) {
                    dummy = dummy.getNextSibling();
                }
                this.root = (Element)dummy;
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void addActivityStatus(boolean active) {
            if (active) {
                this.root.setAttribute("active", "yes");
            } else {
                this.root.setAttribute("active", "no");
            }
        }

        private void addDisplayName(String displayName) {
            Element dummyNode = this.doc.createElement("display-name");
            Text text = this.doc.createTextNode(displayName);
            dummyNode.appendChild(text);
            Node dummy = this.root.getFirstChild();
            while (dummy.getNodeType() != 1 || !dummy.getNodeName().equalsIgnoreCase("login-module")) {
                dummy = dummy.getNextSibling();
            }
            this.root.insertBefore(dummyNode, dummy);
        }

        private void addDescription(String description) {
            Element dummyNode = this.doc.createElement("description");
            Text text = this.doc.createTextNode(description);
            dummyNode.appendChild(text);
            Node dummy = this.root.getFirstChild();
            while (dummy.getNodeType() != 1 || !dummy.getNodeName().equalsIgnoreCase("login-module")) {
                dummy = dummy.getNextSibling();
            }
            this.root.insertBefore(dummyNode, dummy);
        }

        private void addUserClassName(String userClassName) {
            Element dummyNode = this.doc.createElement("user-class-name");
            Text text = this.doc.createTextNode(userClassName);
            dummyNode.appendChild(text);
            Node dummy = this.root.getFirstChild();
            while (dummy.getNodeType() != 1 || !dummy.getNodeName().equalsIgnoreCase("login-module")) {
                dummy = dummy.getNextSibling();
            }
            this.root.insertBefore(dummyNode, dummy);
        }

        private void addGroupClassName(String groupClassName) {
            Element dummyNode = this.doc.createElement("group-class-name");
            Text text = this.doc.createTextNode(groupClassName);
            dummyNode.appendChild(text);
            Node dummy = this.root.getFirstChild();
            while (dummy.getNodeType() != 1 || !dummy.getNodeName().equalsIgnoreCase("login-module")) {
                dummy = dummy.getNextSibling();
            }
            this.root.insertBefore(dummyNode, dummy);
        }

        private void addAnonymous(String uid) {
            Element anonymous = this.doc.createElement("anonymous-user");
            Text name = this.doc.createTextNode(uid);
            anonymous.appendChild(name);
            Node dummy = this.root.getFirstChild();
            while (dummy.getNodeType() != 1 || !dummy.getNodeName().equalsIgnoreCase("login-module")) {
                dummy = dummy.getNextSibling();
            }
            this.root.insertBefore(anonymous, dummy);
        }

        private void addAdmins(String[] users, String[] groups) {
            Element user = this.doc.createElement("startup-configuration");
            StringBuffer userString = new StringBuffer();
            int i = 0;
            while (i < users.length) {
                userString.append(users[i]);
                if (i < users.length - 1) {
                    userString.append(",");
                }
                ++i;
            }
            user.setAttribute("UME_ADMIN_USERS", userString.toString());
            this.root.appendChild(user);
            Element group = this.doc.createElement("startup-configuration");
            StringBuffer groupString = new StringBuffer();
            int i2 = 0;
            while (i2 < groups.length) {
                groupString.append(groups[i2]);
                if (i2 < groups.length - 1) {
                    groupString.append(",");
                }
                ++i2;
            }
            group.setAttribute("UME_ADMIN_GROUPS", groupString.toString());
            this.root.appendChild(group);
        }

        private void addGenericConfig(String attribute, String value) {
            Element user = this.doc.createElement("configuration");
            user.setAttribute(attribute, value);
            this.root.appendChild(user);
        }

        private void addUser(String uid, String pwd, String[] parents, boolean isLocked, boolean noCreate) {
            Element user = this.doc.createElement("startup-configuration");
            user.setAttribute("user" + this.usrGrpCount + ".name", uid);
            user.setAttribute("user" + this.usrGrpCount + ".isUser", "true");
            user.setAttribute("user" + this.usrGrpCount + ".password", pwd);
            StringBuffer parentString = new StringBuffer();
            int i = 0;
            while (i < parents.length) {
                parentString.append(parents[i]);
                if (i < parents.length - 1) {
                    parentString.append(",");
                }
                ++i;
            }
            user.setAttribute("user" + this.usrGrpCount + ".parentGroups", parentString.toString());
            user.setAttribute("user" + this.usrGrpCount + ".isLocked", new Boolean(isLocked).toString());
            user.setAttribute("user" + this.usrGrpCount + ".noCreate", new Boolean(noCreate).toString());
            this.root.appendChild(user);
            ++this.usrGrpCount;
        }

        private void addGroup(String gid, String[] parents, boolean noCreate) {
            Element group = this.doc.createElement("startup-configuration");
            group.setAttribute("user" + this.usrGrpCount + ".name", gid);
            group.setAttribute("user" + this.usrGrpCount + ".isUser", "false");
            group.setAttribute("user" + this.usrGrpCount + ".password", "");
            String parentString = "";
            int i = 0;
            while (i < parents.length) {
                parentString.concat(parents[i]);
                if (i < parents.length - 1) {
                    parentString.concat(",");
                }
                ++i;
            }
            group.setAttribute("user" + this.usrGrpCount + ".parentGroups", parentString);
            group.setAttribute("user" + this.usrGrpCount + ".noCreate", new Boolean(noCreate).toString());
            this.root.appendChild(group);
            ++this.usrGrpCount;
        }

        private Node getNodes() {
            return this.root;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class Policy {
        private Document doc = null;
        private Element root = null;
        private int usrGrpCount = 1;
        static /* synthetic */ Class class$com$sap$security$tools$WizardModelXML;

        Policy(String template) {
            WizardModelXML.this.factory = DocumentBuilderFactory.newInstance();
            WizardModelXML.this.factory.setNamespaceAware(true);
            WizardModelXML.this.factory.setValidating(false);
            try {
                WizardModelXML.this.documentBuilder = WizardModelXML.this.factory.newDocumentBuilder();
                this.doc = WizardModelXML.this.documentBuilder.parse((class$com$sap$security$tools$WizardModelXML == null ? (class$com$sap$security$tools$WizardModelXML = Policy.class$("com.sap.security.tools.WizardModelXML")) : class$com$sap$security$tools$WizardModelXML).getResourceAsStream(template));
                Node dummy = this.doc.getFirstChild();
                while (dummy.getNodeType() != 1 || !dummy.getNodeName().equalsIgnoreCase("policy")) {
                    dummy = dummy.getNextSibling();
                }
                this.root = (Element)dummy;
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void addUserStoreName(String userStoreName) {
            this.root.setAttribute("userstore", userStoreName);
        }

        private void addConfigurationTicket(boolean activeUME) {
            Element config = this.doc.createElement("configuration");
            config.setAttribute("name", "ticket");
            Element authentication = this.doc.createElement("authentication");
            Element entry = this.doc.createElement("entry");
            Element classNameEl = this.doc.createElement("classname");
            Text classNameTxt = this.doc.createTextNode("com.sap.security.core.server.jaas.EvaluateTicketLoginModule");
            classNameEl.appendChild(classNameTxt);
            entry.appendChild(classNameEl);
            Element flagEl = this.doc.createElement("flag");
            Text flagTxt = this.doc.createTextNode("sufficient");
            flagEl.appendChild(flagTxt);
            entry.appendChild(flagEl);
            Element optionEl = this.doc.createElement("option");
            if (activeUME) {
                optionEl.setAttribute("ume.configuration.active", "true");
            }
            entry.appendChild(optionEl);
            authentication.appendChild(entry);
            entry = this.doc.createElement("entry");
            classNameEl = this.doc.createElement("classname");
            classNameTxt = this.doc.createTextNode("com.sap.engine.services.security.server.jaas.BasicPasswordLoginModule");
            classNameEl.appendChild(classNameTxt);
            entry.appendChild(classNameEl);
            flagEl = this.doc.createElement("flag");
            flagTxt = this.doc.createTextNode("requisite");
            flagEl.appendChild(flagTxt);
            entry.appendChild(flagEl);
            optionEl = this.doc.createElement("option");
            entry.appendChild(optionEl);
            authentication.appendChild(entry);
            entry = this.doc.createElement("entry");
            classNameEl = this.doc.createElement("classname");
            classNameTxt = this.doc.createTextNode("com.sap.security.core.server.jaas.CreateTicketLoginModule");
            classNameEl.appendChild(classNameTxt);
            entry.appendChild(classNameEl);
            flagEl = this.doc.createElement("flag");
            flagTxt = this.doc.createTextNode("optional");
            flagEl.appendChild(flagTxt);
            entry.appendChild(flagEl);
            optionEl = this.doc.createElement("option");
            if (activeUME) {
                optionEl.setAttribute("ume.configuration.active", "true");
            }
            entry.appendChild(optionEl);
            authentication.appendChild(entry);
            config.appendChild(authentication);
            this.root.appendChild(config);
        }

        private void addConfigurationJ2EE(String adminGrpName, String guestGrpName, String allGrpName) {
            Element config = this.doc.createElement("configuration");
            config.setAttribute("name", "SAP-J2EE-Engine");
            Element authentication = this.doc.createElement("authentication");
            Element entry = this.doc.createElement("entry");
            Element classNameEl = this.doc.createElement("classname");
            Text classNameTxt = this.doc.createTextNode("com.sap.engine.services.security.server.jaas.BasicPasswordLoginModule");
            classNameEl.appendChild(classNameTxt);
            entry.appendChild(classNameEl);
            Element flagEl = this.doc.createElement("flag");
            Text flagTxt = this.doc.createTextNode("sufficient");
            flagEl.appendChild(flagTxt);
            entry.appendChild(flagEl);
            Element optionEl = this.doc.createElement("option");
            entry.appendChild(optionEl);
            authentication.appendChild(entry);
            config.appendChild(authentication);
            Element authorization = this.doc.createElement("authorization");
            Element adminRole = this.doc.createElement("security-role");
            adminRole.setAttribute("name", "administrators");
            Element adminGrpEl = this.doc.createElement("group");
            Text adminGrpTxt = this.doc.createTextNode(adminGrpName);
            adminGrpEl.appendChild(adminGrpTxt);
            adminRole.appendChild(adminGrpEl);
            authorization.appendChild(adminRole);
            Element guestRole = this.doc.createElement("security-role");
            guestRole.setAttribute("name", "guests");
            Element guestGrpEl = this.doc.createElement("group");
            Text guestGrpTxt = this.doc.createTextNode(guestGrpName);
            guestGrpEl.appendChild(guestGrpTxt);
            guestRole.appendChild(guestGrpEl);
            authorization.appendChild(guestRole);
            Element allRole = this.doc.createElement("security-role");
            allRole.setAttribute("name", "all");
            Element allGrpEl = this.doc.createElement("group");
            Text allGrpTxt = this.doc.createTextNode(allGrpName);
            allGrpEl.appendChild(allGrpTxt);
            allRole.appendChild(allGrpEl);
            authorization.appendChild(allRole);
            config.appendChild(authorization);
            this.root.appendChild(config);
        }

        private void addConfigurationNaming(String adminGrpName, String allGrpName) {
            Element config = this.doc.createElement("configuration");
            config.setAttribute("name", "service.naming");
            Element authentication = this.doc.createElement("authentication");
            Element template = this.doc.createElement("template");
            Text name = this.doc.createTextNode("SAP-J2EE-Engine");
            template.appendChild(name);
            authentication.appendChild(template);
            config.appendChild(authentication);
            Element authorization = this.doc.createElement("authorization");
            Element adminRole = this.doc.createElement("security-role");
            adminRole.setAttribute("name", "jndi_all_operations");
            Element adminGrpEl = this.doc.createElement("group");
            Text adminGrpTxt = this.doc.createTextNode(adminGrpName);
            adminGrpEl.appendChild(adminGrpTxt);
            adminRole.appendChild(adminGrpEl);
            authorization.appendChild(adminRole);
            Element allRole = this.doc.createElement("security-role");
            allRole.setAttribute("name", "jndi_get_initial_context");
            Element allGrpEl = this.doc.createElement("group");
            Text allGrpTxt = this.doc.createTextNode(allGrpName);
            allGrpEl.appendChild(allGrpTxt);
            allRole.appendChild(allGrpEl);
            authorization.appendChild(allRole);
            config.appendChild(authorization);
            this.root.appendChild(config);
        }

        private void addConfigurationTelnet(String adminGrpName) {
            Element config = this.doc.createElement("configuration");
            config.setAttribute("name", "service.telnet");
            Element authentication = this.doc.createElement("authentication");
            Element template = this.doc.createElement("template");
            Text name = this.doc.createTextNode("SAP-J2EE-Engine");
            template.appendChild(name);
            authentication.appendChild(template);
            config.appendChild(authentication);
            Element authorization = this.doc.createElement("authorization");
            Element adminRole = this.doc.createElement("security-role");
            adminRole.setAttribute("name", "telnet_login");
            Element adminGrpEl = this.doc.createElement("group");
            Text adminGrpTxt = this.doc.createTextNode(adminGrpName);
            adminGrpEl.appendChild(adminGrpTxt);
            adminRole.appendChild(adminGrpEl);
            authorization.appendChild(adminRole);
            config.appendChild(authorization);
            this.root.appendChild(config);
        }

        private Node getNodes() {
            return this.root;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

