/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.ticket;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class InfoUnit {
    public static final int ID_USER = 1;
    public static final int ID_CREATE_CLIENT = 2;
    public static final int ID_CREATE_NAME = 3;
    public static final int ID_CREATE_TIME = 4;
    public static final int ID_VALID_TIME = 5;
    public static final int ID_RFC = 6;
    public static final int ID_VALID_TIME_MIN = 7;
    public static final int ID_FLAGS = 8;
    public static final int ID_SIGNATURE = 255;
    public static final int ID_LANGUAGE = 9;
    public static final int ID_USER_UTF = 10;
    public static final int ID_CREATE_CLIENT_UTF = 11;
    public static final int ID_CREATE_NAME_UTF = 12;
    public static final int ID_CREATE_TIME_UTF = 13;
    public static final int ID_LANGUAGE_UTF = 14;
    public static final int ID_AUTH_TYPE = 15;
    public static HashMap codepageEncoding = new HashMap();
    private int id;
    private byte[] content;

    public InfoUnit(InputStream in, int id, int len) throws IOException {
        this.id = id;
        this.content = InfoUnit.readRaw(in, len);
    }

    public InfoUnit(int id, byte[] data) {
        this.id = id;
        this.content = data;
    }

    public int getID() {
        return this.id;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return InfoUnit.bytesToString(this.content, encoding);
    }

    public int getInt() {
        return InfoUnit.bytesToInt(this.content);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.id);
        out.write(this.content.length >> 8 & 0xFF);
        out.write(this.content.length & 0xFF);
        out.write(this.content);
    }

    public static InfoUnit readInfoUnit(InputStream in) throws IOException {
        int id = in.read();
        if (id < 0) {
            return null;
        }
        int len = InfoUnit.bytesToInt(InfoUnit.readRaw(in, 2));
        return new InfoUnit(in, id, len);
    }

    public static int bytesToInt(byte[] buffer) {
        return InfoUnit.bytesToInt(buffer, 0, buffer.length);
    }

    public static int bytesToInt(byte[] buffer, int offset, int length) {
        int x = 0;
        int i = 0;
        while (i < length) {
            int z = buffer[offset];
            if (z < 0) {
                z += 256;
            }
            x = (x << 8) + z;
            ++i;
            ++offset;
        }
        return x;
    }

    public static byte[] IntToBytes(int i) {
        byte[] b = new byte[4];
        b[3] = (byte)(i % 256);
        b[2] = (byte)((i /= 256) % 256);
        b[1] = (byte)((i /= 256) % 256);
        b[0] = (byte)((i /= 256) % 256);
        i /= 256;
        return b;
    }

    public static String bytesToString(byte[] buffer, String encoding) throws UnsupportedEncodingException {
        return InfoUnit.bytesToString(buffer, 0, buffer.length, encoding);
    }

    public static String bytesToString(byte[] buffer, int offset, int length, String encoding) throws UnsupportedEncodingException {
        ByteArrayInputStream ba = new ByteArrayInputStream(buffer, offset, length);
        InputStreamReader in = encoding == null ? new InputStreamReader(ba) : new InputStreamReader((InputStream)ba, encoding);
        StringBuffer s = new StringBuffer();
        try {
            int c = in.read();
            while (c > 0) {
                s.append((char)c);
                c = in.read();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return s.toString();
    }

    public static byte[] readRaw(InputStream in, int n) throws IOException {
        byte[] buffer = new byte[n];
        int i = 0;
        while (i < n) {
            int c = in.read();
            if (c < 0) break;
            buffer[i] = (byte)c;
            ++i;
        }
        return buffer;
    }

    public static byte[] jcharToSAPCP(String source, String SAPCodepage) throws UnsupportedEncodingException, IOException {
        String encoding = null;
        encoding = (String)codepageEncoding.get(SAPCodepage);
        if (null == encoding) {
            throw new UnsupportedEncodingException("Java doesn't support SAP codepage " + SAPCodepage);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter CpWriter = new OutputStreamWriter((OutputStream)baos, encoding);
        CpWriter.write(source);
        CpWriter.flush();
        return baos.toByteArray();
    }

    public static byte[] jcharToUTF8(String source) throws UnsupportedEncodingException, IOException {
        return InfoUnit.jcharToSAPCP(source, "4110");
    }

    static {
        codepageEncoding.put("4110", "UTF8");
        codepageEncoding.put("1100", "ISO8859_1");
        codepageEncoding.put("1140", "ISO8859_1");
        codepageEncoding.put("1401", "ISO8859_2");
        codepageEncoding.put("1500", "ISO8859_5");
        codepageEncoding.put("1610", "ISO8859_9");
        codepageEncoding.put("1700", "ISO8859_7");
        codepageEncoding.put("1800", "ISO8859_8");
        codepageEncoding.put("1900", "ISO8859_4");
        codepageEncoding.put("8200", "ISO2022JP");
        codepageEncoding.put("8700", "ISO8859_4");
        codepageEncoding.put("0120", "Cp500");
        codepageEncoding.put("1103", "Cp850");
        codepageEncoding.put("1404", "Cp1250");
        codepageEncoding.put("1504", "Cp1251");
        codepageEncoding.put("1614", "Cp1254");
        codepageEncoding.put("1704", "Cp1253");
        codepageEncoding.put("1804", "Cp1255");
        codepageEncoding.put("1904", "Cp1257");
        codepageEncoding.put("8604", "Cp874");
        codepageEncoding.put("8704", "Cp1256");
        codepageEncoding.put("8000", "SJIS");
        codepageEncoding.put("8100", "EUC_JP");
        codepageEncoding.put("8300", "Big5");
        codepageEncoding.put("8600", "TIS620");
        codepageEncoding.put("8400", "ISO2022CN_GB");
        codepageEncoding.put("8500", "EUC_KR");
        codepageEncoding.put("4103", "UnicodeLittleUnmarked");
    }
}

