/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.roles;

import com.sap.security.roles.IRole;
import java.io.Serializable;
import java.security.Principal;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;

public class Role
implements IRole,
Principal,
Serializable {
    private String m_name;
    private String m_description;
    private boolean m_relevant;
    private IRole[] m_children;
    public static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return Collator.getInstance().compare(((IRole)o1).getName(), ((IRole)o2).getName());
        }
    };

    public Role(String name) {
        if (name == null) {
            throw new NullPointerException("The role name must not be null");
        }
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public boolean isRelevant() {
        return this.m_relevant;
    }

    public void setRelevant(boolean relevant) {
        this.m_relevant = relevant;
    }

    public IRole[] getChildren() {
        if (this.m_children == null) {
            return new IRole[0];
        }
        return this.m_children;
    }

    public void addChild(IRole role) {
        if (this.m_children == null) {
            this.m_children = new IRole[]{role};
        } else {
            int idx = Arrays.binarySearch(this.m_children, role, COMPARATOR);
            if (idx < 0) {
                int insPoint = (idx + 1) * -1;
                IRole[] children = new IRole[this.m_children.length + 1];
                System.arraycopy(this.m_children, 0, children, 0, insPoint);
                children[insPoint] = role;
                int tail = this.m_children.length - insPoint;
                if (tail > 0) {
                    System.arraycopy(this.m_children, insPoint, children, insPoint + 1, tail);
                }
                this.m_children = children;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(':');
        sb.append("\n   Name: ").append(this.m_name);
        sb.append("\n   Description: ").append(this.m_description);
        sb.append("\n   Relevant for J2EE: ").append(this.m_relevant);
        int cntChildren = this.m_children != null ? this.m_children.length : 0;
        sb.append("\n   Child Roles: ").append(cntChildren);
        sb.append("\n");
        return sb.toString();
    }

    public boolean equals(Object o) {
        return o instanceof Role && this.m_name.equals(((Role)o).getName());
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }
}

