/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security;

import com.sap.security.um.ILookup;
import com.sap.security.usermanagement.IAuthentication;
import com.sap.security.usermanagement.IConfigurable;
import com.sap.security.usermanagement.IUserAccountFactory;
import com.sap.security.usermanagement.IUserFactory;
import com.sap.security.util.LogUtil;
import com.sap.security.util.SAPBasis;
import com.sap.security.util.TaggedProperties;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Security {
    public static final String VERSION = "$Id: //shared_tc/com.sap.security.core.server/630_VAL_REL/src/_compat/java/_core/com/sap/security/Security.java#1 $ from $DateTime: 2004/03/08 16:48:25 $ ($Change: 14740 $)";
    private static final Map USER_FACTORIES = new HashMap();
    private static final Map USER_ACCOUNT_FACTORIES = new HashMap();
    private static final Map AUTHENTICATIONS = new HashMap();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$Security == null ? (class$com$sap$security$Security = Security.class$("com.sap.security.Security")) : class$com$sap$security$Security));
    private static final Category CATEGORY = Category.getCategory((String)"/Security");
    private static final LogUtil LOG_UTIL = new LogUtil(LOCATION, CATEGORY);
    static /* synthetic */ Class class$com$sap$security$Security;
    static /* synthetic */ Class class$com$sap$security$usermanagement$IUserFactory;
    static /* synthetic */ Class class$com$sap$security$usermanagement$IUserAccountFactory;
    static /* synthetic */ Class class$com$sap$security$usermanagement$IAuthentication;

    private Security() {
    }

    public static IUserFactory getUserFactory() {
        return Security.getUserFactory(null);
    }

    public static IUserAccountFactory getUserAccountFactory() {
        return Security.getUserAccountFactory(null);
    }

    public static IAuthentication getAuthentication() {
        return Security.getAuthentication(null);
    }

    public static synchronized IUserFactory getUserFactory(String key) {
        return (IUserFactory)USER_FACTORIES.get(key);
    }

    public static synchronized IUserAccountFactory getUserAccountFactory(String key) {
        return (IUserAccountFactory)USER_ACCOUNT_FACTORIES.get(key);
    }

    public static synchronized IAuthentication getAuthentication(String key) {
        return (IAuthentication)AUTHENTICATIONS.get(key);
    }

    public static void register(String key, IUserFactory userFactory) {
        Security.register(key, userFactory, USER_FACTORIES);
    }

    public static void register(String key, IUserAccountFactory userAccountFactory) {
        Security.register(key, userAccountFactory, USER_ACCOUNT_FACTORIES);
    }

    public static void register(String key, IAuthentication authentication) {
        Security.register(key, authentication, AUTHENTICATIONS);
    }

    private static synchronized void register(String key, Object o, Map instances) {
        instances.put(key, o);
        if (o instanceof ILookup) {
            ((ILookup)o).setKey(key);
        }
    }

    public static boolean unregister(IUserFactory userFactory) {
        return Security.unregister(userFactory, USER_FACTORIES);
    }

    public static boolean unregister(IUserAccountFactory userAccountFactory) {
        return Security.unregister(userAccountFactory, USER_ACCOUNT_FACTORIES);
    }

    public static boolean unregister(IAuthentication authentication) {
        return Security.unregister(authentication, AUTHENTICATIONS);
    }

    private static synchronized boolean unregister(Object o, Map instances) {
        String method = "unregister(Object,Map)";
        LOCATION.entering("unregister(Object,Map)", new Object[]{o, instances});
        Set entries = instances.entrySet();
        Iterator iter = entries.iterator();
        boolean found = false;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getValue() != o) continue;
            found = true;
            iter.remove();
            LOCATION.debugT(CATEGORY, "unregister(Object,Map)", String.valueOf(o) + " unregistered successfully (key=" + entry.getKey() + ")");
        }
        if (!found) {
            LOCATION.debugT(CATEGORY, "unregister(Object,Map)", String.valueOf(o) + " is not registered in the Security class. " + "No instances have been unregistered.");
        }
        LOCATION.exiting();
        return found;
    }

    public static synchronized void unregisterAll() {
        String method = "unregisterAll()";
        LOCATION.entering(CATEGORY, "unregisterAll()");
        USER_FACTORIES.clear();
        USER_ACCOUNT_FACTORIES.clear();
        AUTHENTICATIONS.clear();
        LOCATION.exiting();
    }

    public static synchronized void init(Properties p, String instance_id) throws Exception {
        String method = "init(Properties,String)";
        LOCATION.entering(CATEGORY, "init(Properties,String)", new Object[]{p, instance_id});
        try {
            TaggedProperties pTagged = new TaggedProperties(p);
            if (instance_id != null) {
                ((Hashtable)p).putAll(pTagged.getProperties("clusterelement", instance_id));
                pTagged = new TaggedProperties(p);
                StringWriter sw = new StringWriter();
                p.list(new PrintWriter(sw));
                LOCATION.debugT(CATEGORY, "init(Properties,String)", "Replaced global with instance-specific data:\n" + sw.toString());
            }
            Map mUserFactories = Security.getComponents("userfactory", class$com$sap$security$usermanagement$IUserFactory == null ? (class$com$sap$security$usermanagement$IUserFactory = Security.class$("com.sap.security.usermanagement.IUserFactory")) : class$com$sap$security$usermanagement$IUserFactory, pTagged);
            Map mUserAccountFactories = Security.getComponents("useraccountfactory", class$com$sap$security$usermanagement$IUserAccountFactory == null ? (class$com$sap$security$usermanagement$IUserAccountFactory = Security.class$("com.sap.security.usermanagement.IUserAccountFactory")) : class$com$sap$security$usermanagement$IUserAccountFactory, pTagged);
            Map mAuthentications = Security.getComponents("authentication", class$com$sap$security$usermanagement$IAuthentication == null ? (class$com$sap$security$usermanagement$IAuthentication = Security.class$("com.sap.security.usermanagement.IAuthentication")) : class$com$sap$security$usermanagement$IAuthentication, pTagged);
            USER_FACTORIES.putAll(mUserFactories);
            USER_ACCOUNT_FACTORIES.putAll(mUserAccountFactories);
            AUTHENTICATIONS.putAll(mAuthentications);
            LOCATION.exiting();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            LOCATION.errorT(CATEGORY, "init(Properties,String)", sw.toString());
            throw e;
        }
    }

    private static Map getComponents(String prefix, Class clInterface, TaggedProperties pTagged) throws Exception {
        String method = "getComponents(String,Class,TaggedProperties)";
        LOCATION.entering(CATEGORY, "getComponents(String,Class,TaggedProperties)", new Object[]{prefix, clInterface, pTagged});
        String[] tags = pTagged.getTags(prefix);
        if (tags.length == 0 && ("userfactory".equals(prefix) || "useraccountfactory".equals(prefix)) && SAPBasis.getSAPBasis() != null) {
            Properties p = new Properties();
            p.setProperty(prefix + ".class", "com.sap.security.um.r3.R3UserFactory");
            pTagged = new TaggedProperties(p);
            tags = pTagged.getTags(prefix);
        }
        HashMap m = new HashMap();
        int i = 0;
        while (i < tags.length) {
            Properties pWork = pTagged.getProperties(prefix, tags[i]);
            String className = pWork.getProperty("class");
            if (className == null) {
                throw new Exception("No provider class specified for " + prefix + tags[i] == null ? "" : "[" + tags[i] + "]");
            }
            Object o = Class.forName(className).newInstance();
            if (!clInterface.isInstance(o)) {
                throw new Exception(o.getClass().getName() + " does not implement " + clInterface.getName());
            }
            if (o instanceof IConfigurable) {
                ((IConfigurable)o).initialize(pWork);
                LOCATION.infoT(CATEGORY, "getComponents(String,Class,TaggedProperties)", clInterface.getName() + " [" + tags[i] + "] initialized successfully");
            }
            if (o instanceof ILookup) {
                ((ILookup)o).setKey(tags[i]);
                LOCATION.infoT(CATEGORY, "getComponents(String,Class,TaggedProperties)", "Lookup key of " + clInterface.getName() + " [" + tags[i] + "]  set to " + tags[i]);
            }
            m.put(tags[i], o);
            ++i;
        }
        LOCATION.exiting();
        return m;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

