/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.securitypolicy.assertions;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.security.core.securitypolicy.assertions.AlgorithmElement;
import com.sap.security.core.ws.mapping.ExtendableElement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MessagePartsElement
extends ExtendableElement {
    private String dialect = "http://www.w3.orig/TR/1999/REC-xpath-19991116";
    private String signer;
    private String uri;
    private List namespaceList = new ArrayList();
    private List algorithmList = new ArrayList();

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public String getSigner() {
        return this.signer;
    }

    public void setSigner(String signer) {
        this.signer = signer;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void addAlgorithm(AlgorithmElement algorithmElement) {
        this.algorithmList.add(algorithmElement);
    }

    public Iterator getAlgorithms() {
        return this.algorithmList.iterator();
    }

    public List getAlgorithmsByType(String algorithmType) {
        ArrayList<AlgorithmElement> selectedAlgorithmsList = new ArrayList<AlgorithmElement>();
        Iterator algorithmIterator = this.algorithmList.iterator();
        while (algorithmIterator.hasNext()) {
            AlgorithmElement algorithm = (AlgorithmElement)algorithmIterator.next();
            if (!algorithmType.equals(algorithm.getType())) continue;
            selectedAlgorithmsList.add(algorithm);
        }
        return selectedAlgorithmsList;
    }

    public void addNamespace(String namespace) {
        this.namespaceList.add(namespace);
    }

    public Iterator getNamespaces() {
        return this.namespaceList.iterator();
    }

    private String replaceLocalNames(Hashtable namespaceMappingHashtable, String path) {
        Enumeration keyEnumeration = namespaceMappingHashtable.keys();
        while (keyEnumeration.hasMoreElements()) {
            String localName = (String)keyEnumeration.nextElement();
            while (path.indexOf(localName + ":") != -1) {
                int index0 = path.indexOf(localName + ":");
                path = path.substring(0, index0) + "{" + namespaceMappingHashtable.get(localName) + "}" + path.substring(index0 + localName.length());
            }
        }
        return path;
    }

    public boolean equalsURI(Element signedElement) {
        Hashtable<String, String> definedNamespaceHashtable = new Hashtable<String, String>();
        Iterator nsIterator = this.getNamespaces();
        while (nsIterator.hasNext()) {
            String nsDeclaration = (String)nsIterator.next();
            if (nsDeclaration.indexOf("=") == -1) continue;
            int index = nsDeclaration.indexOf("=");
            String localname = nsDeclaration.substring(0, index).trim();
            String nsURI = nsDeclaration.substring(index + 1).trim();
            definedNamespaceHashtable.put(localname, nsURI);
        }
        String policyPath = this.replaceLocalNames(definedNamespaceHashtable, this.getURI());
        Hashtable namespaceMappingHashtable = DOM.getNamespaceMappingsInScope((Node)signedElement);
        String documentPath = this.replaceLocalNames(namespaceMappingHashtable, DOM.toXPath((Node)signedElement));
        return policyPath.equals(documentPath);
    }
}

