/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.policy;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class PolicyTemplateInfoManager {
    Properties inboundProperties;
    Properties outboundProperties;
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$policy$PolicyTemplateInfoManager == null ? (class$com$sap$security$core$policy$PolicyTemplateInfoManager = PolicyTemplateInfoManager.class$("com.sap.security.core.policy.PolicyTemplateInfoManager")) : class$com$sap$security$core$policy$PolicyTemplateInfoManager));
    final Category CATEGORY = Category.SYS_SECURITY;
    static /* synthetic */ Class class$com$sap$security$core$policy$PolicyTemplateInfoManager;

    public PolicyTemplateInfoManager() {
        this.inboundProperties = new Properties();
        this.outboundProperties = new Properties();
        try {
            this.inboundProperties.load(this.getClass().getResourceAsStream("/policy/inbound.properties"));
            this.outboundProperties.load(this.getClass().getResourceAsStream("/policy/outbound.properties"));
        }
        catch (IOException ex) {
            LOCATION.catching(this.CATEGORY, (Throwable)ex);
        }
    }

    public List getInboundPolicyNames() {
        ArrayList<String> returnList = new ArrayList<String>();
        Iterator keyIterator = ((Hashtable)this.inboundProperties).keySet().iterator();
        while (keyIterator.hasNext()) {
            String keyName = (String)keyIterator.next();
            if (keyName.indexOf(".") != -1) continue;
            returnList.add(keyName);
        }
        returnList.remove("None");
        returnList.add(0, "None");
        return returnList;
    }

    public List getOutboundPolicyNames() {
        ArrayList<String> returnList = new ArrayList<String>();
        Iterator keyIterator = ((Hashtable)this.outboundProperties).keySet().iterator();
        while (keyIterator.hasNext()) {
            String keyName = (String)keyIterator.next();
            if (keyName.indexOf(".") != -1) continue;
            returnList.add(keyName);
        }
        returnList.remove("None");
        returnList.add(0, "None");
        return returnList;
    }

    private List getPolicyNamesByFeature(List policyNames, Properties policyProperties, String featureName) {
        ArrayList<String> returnList = new ArrayList<String>();
        Iterator policyIterator = policyNames.iterator();
        while (policyIterator.hasNext()) {
            String policyName = (String)policyIterator.next();
            boolean containsFeature = false;
            StringTokenizer st = new StringTokenizer(policyProperties.getProperty(policyName + ".features", ""), ";");
            while (st.hasMoreTokens()) {
                if (!featureName.equals(st.nextToken())) continue;
                containsFeature = true;
            }
            if (!containsFeature) continue;
            returnList.add(policyName);
        }
        return returnList;
    }

    public List getInboundPolicyNamesByFeature(String featureName) {
        return this.getPolicyNamesByFeature(this.getInboundPolicyNames(), this.inboundProperties, featureName);
    }

    public List getOutboundPolicyNamesByFeature(String featureName) {
        return this.getPolicyNamesByFeature(this.getOutboundPolicyNames(), this.outboundProperties, featureName);
    }

    public String getInboundPolicyShortDescription(String policyName) {
        return this.inboundProperties.getProperty(policyName + ".description", "");
    }

    public String getOutboundPolicyShortDescription(String policyName) {
        return this.outboundProperties.getProperty(policyName + ".description", "");
    }

    public int getInboundPolicyVersion(String policyName) {
        return Integer.parseInt(this.inboundProperties.getProperty(policyName + ".version", ""));
    }

    public int getOutboundPolicyVersion(String policyName) {
        return Integer.parseInt(this.outboundProperties.getProperty(policyName + ".version", ""));
    }

    public InputStream getInboundPolicyTemplateAsStream(String policyName) {
        return this.getClass().getResourceAsStream(this.inboundProperties.getProperty(policyName));
    }

    public InputStream getOutboundPolicyTemplateAsStream(String policyName) {
        return this.getClass().getResourceAsStream(this.outboundProperties.getProperty(policyName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

