/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.client.ws;

import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractProtocol;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.RuntimeInformation;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.HTTPTransportInterface;
import com.sap.security.core.client.ws.AuthenticationContext;
import com.sap.security.core.client.ws.DeployableAuthenticationContext;
import com.sap.security.core.client.ws.wdhelper.WSSecurityWDHelper;
import java.util.Enumeration;
import java.util.Hashtable;

public class SecurityProtocol
implements AbstractProtocol {
    public static final String PROTOCOL_NAME = "SecurityProtocol";
    private AuthenticationContext authenticationContext;
    private Hashtable headerHashtable = new Hashtable();
    private PropertyContext authenticationFeatureContext;
    private boolean invalidateSession = false;

    public void init(PropertyContext ctx) {
        if (ctx.isDefined()) {
            this.authenticationFeatureContext = ctx.getSubContext("http://www.sap.com/webas/630/soap/features/authentication");
            this.authenticationContext = new AuthenticationContext(this.authenticationFeatureContext);
        }
    }

    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public String[] getFeatures() {
        return new String[]{"http://www.sap.com/webas/630/soap/features/authentication"};
    }

    public String getName() {
        return PROTOCOL_NAME;
    }

    public boolean isFeatureImplemented(String featureName, PropertyContext arg1) {
        return "http://www.sap.com/webas/630/soap/features/authentication".equals(featureName);
    }

    public boolean handleFault(AbstractMessage arg0, PropertyContext arg1) throws ClientProtocolException {
        return true;
    }

    protected void internalSetHTTPHeaders(PropertyContext context) {
        Object transportInterface = context.getProperty("transportInterface");
        if (transportInterface != null && transportInterface instanceof HTTPTransportInterface) {
            HTTPTransportInterface http = (HTTPTransportInterface)transportInterface;
            Enumeration keys = http.listHeaders();
            Enumeration keyEnumerator = this.headerHashtable.keys();
            while (keyEnumerator.hasMoreElements()) {
                String key = (String)keyEnumerator.nextElement();
                http.setHeader(key, (String)this.headerHashtable.get(key));
            }
        }
    }

    public boolean handleRequest(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        String destinationName = "";
        destinationName = (String)context.getSubContext("featureConfig").getProperty("Destination");
        if (!"".equals(destinationName) && destinationName != null) {
            WSSecurityWDHelper wdHelper = new WSSecurityWDHelper();
            this.setAuthenticationContext(wdHelper.getDeployableAuthenticationContext(this.authenticationFeatureContext));
            ((DeployableAuthenticationContext)this.authenticationContext).setHTTPDestination(destinationName, context);
            String destinationUrl = wdHelper.getDestinationUrl(destinationName);
            if (destinationUrl != null && !"".equals(destinationUrl)) {
                wdHelper.setHTTPEndpoint(destinationUrl, context);
            }
        }
        Hashtable authenticationHeadersHashtable = this.getAuthenticationContext().getHttpHeaderHashtable();
        Enumeration headerNamesEnumeration = authenticationHeadersHashtable.keys();
        while (headerNamesEnumeration.hasMoreElements()) {
            String name = (String)headerNamesEnumeration.nextElement();
            String value = (String)authenticationHeadersHashtable.get(name);
            this.addHeader(name, value);
        }
        if (this.invalidateSession) {
            PropertyContext sessionFeature = context.getSubContext("featureConfig").getSubContext("http://www.sap.com/webas/630/soap/features/session/");
            if (sessionFeature.isDefined()) {
                sessionFeature.clearProperty("SessionCoockie");
                sessionFeature.setProperty("maintainSession", (Object)"yes");
            }
            this.invalidateSession = false;
        }
        this.internalSetHTTPHeaders(context);
        if (context.getSubContext("featureConfig") != null && context.getSubContext("featureConfig").getProperty("RuntimeInfo") != null) {
            RuntimeInformation runtimInfo = (RuntimeInformation)context.getSubContext("featureConfig").getProperty("RuntimeInfo");
            String name = runtimInfo.getApplicationName() + "/" + runtimInfo.getLogicalPortName();
        }
        return true;
    }

    public boolean handleResponse(AbstractMessage arg0, PropertyContext arg1) throws ClientProtocolException {
        return true;
    }

    public void addHeader(String key, String value) {
        this.headerHashtable.put(key, value);
    }

    protected void display(String path, PropertyContext ctx) {
        String key;
        Enumeration enumeration = ctx.getProperyKeys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            System.out.println(path + "{" + key + "}:value=" + ctx.getProperty(key));
        }
        enumeration = ctx.getSubcontextKeys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            this.display(path + "/" + key, ctx.getSubContext(key));
            System.out.println("SubCtx:" + path + "/" + key);
        }
    }

    protected void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void invalidateSession() {
        this.invalidateSession = true;
    }
}

