/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.test;

import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.ICodeInspector;
import com.togethersoft.sca.core.IProject;
import com.togethersoft.sca.core.ISourceBase;
import com.togethersoft.sca.core.IStaticAnalyzer;
import com.togethersoft.sca.core.plugin.metric.IMetric;
import com.togethersoft.sca.core.plugin.metric.IMetricPlugin;
import com.togethersoft.sca.core.plugin.metric.IMetricResult;
import com.togethersoft.sca.internal.core.ClientSourceBase;
import junit.framework.Assert;
import junit.framework.TestCase;

abstract class MetricTestCase
extends TestCase {
    protected IMetricResult[] results;

    public MetricTestCase(String name) {
        super(name);
    }

    protected void runMetric(String id, String[] files) {
        IProject project = Factory.createProject();
        ClientSourceBase base = Factory.createLocalSourceBase();
        project.addSourceBase((ISourceBase)base);
        int i = 0;
        while (i < files.length) {
            base.addFile(files[i]);
            ++i;
        }
        IStaticAnalyzer platform = Factory.getStaticAnalyzer();
        platform.init(new String[]{"../.."}, null, null);
        project.update(false, null);
        ICodeInspector inspector = platform.getCodeInspector("Metric");
        IMetricPlugin plugin = (IMetricPlugin)inspector.createExecutableCodeInspector();
        IMetric[] metrics = new IMetric[]{plugin.getMetric(inspector.getRegistry().getDescriptor(id))};
        this.results = plugin.measure(project, metrics, null)[0].getResults();
        platform.shutdown();
    }

    protected void verify(String element, int value) {
        IMetricResult res = this.results[0];
        int index = 0;
        block0: while (index < element.length()) {
            String token;
            int newIndex = element.indexOf(47, index);
            if (newIndex >= 0) {
                token = element.substring(index, newIndex);
                index = newIndex + 1;
            } else {
                token = element.substring(index);
                index = element.length();
            }
            IMetricResult[] results = res.getResults();
            int i = 0;
            while (i < results.length) {
                if (results[i].getSubject().getElementName().equals(token)) {
                    res = results[i];
                    continue block0;
                }
                ++i;
            }
            Assert.fail((String)"Element not found");
        }
        Assert.assertEquals((int)value, (int)res.getValue());
    }
}

