/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstMethodCallExpression;
import com.togethersoft.sca.ast.AstObjectCreationExpression;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.ast.visitor.AstExpressionVisitor;
import com.togethersoft.sca.ast.visitor.AstExpressionVisitorAdapter;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;
import java.util.HashSet;
import java.util.Iterator;

public class VOD
extends ClassMetric {
    private boolean ignorePreferred;
    private HashSet acquaintanceClasses;
    private HashSet attrTypes;

    protected void measure(AstType type, MetricResult result) {
        this.acquaintanceClasses = new HashSet();
        this.attrTypes = null;
        AstMethod[] methods = type.getExecutableFragments();
        int i = 0;
        while (i < methods.length) {
            this.processMethod(type, methods[i]);
            ++i;
        }
        result.setValue(this.acquaintanceClasses.size());
        this.acquaintanceClasses = null;
    }

    private void processMethod(AstType type, AstMethod method) {
        AstCompoundStatement body = method.getBody();
        if (body == null) {
            return;
        }
        if (this.attrTypes == null) {
            this.attrTypes = new HashSet();
            AstField[] fields = type.getAllFields();
            int i = 0;
            while (i < fields.length) {
                AstType attrType = fields[i].getType().getBaseType();
                if (attrType != null) {
                    this.attrTypes.add(attrType);
                }
                ++i;
            }
        }
        HashSet<AstType> paramTypes = new HashSet<AstType>();
        AstVariable[] params = method.getParameters();
        int i = 0;
        while (i < params.length) {
            AstType paramType = params[i].getType().getBaseType();
            if (paramType != null) {
                paramTypes.add(paramType);
            }
            ++i;
        }
        ExprVisitor visitor = new ExprVisitor();
        body.visitExpressions((AstExpressionVisitor)visitor);
        HashSet created = visitor.getCreatedClasses();
        HashSet called = visitor.getCalledClasses();
        Iterator iter = called.iterator();
        while (iter.hasNext()) {
            AstType cl = (AstType)iter.next();
            if (type.isDerivedFrom(cl) || cl.getQualifiedName().equals("java/lang/Object") || paramTypes.contains(cl) || this.attrTypes.contains(cl) || this.ignorePreferred && created.contains(cl)) continue;
            this.acquaintanceClasses.add(cl);
        }
    }

    public void setDescriptor(IAnalyzerDescriptor descriptor) {
        super.setDescriptor(descriptor);
        this.ignorePreferred = descriptor.getParameterRegistry().getBooleanValue("Ignore preferred-acquaintance", true);
    }

    private class ExprVisitor
    extends AstExpressionVisitorAdapter {
        private HashSet createdClasses = new HashSet();
        private HashSet calledClasses = new HashSet();

        private ExprVisitor() {
        }

        public void visitObjectCreationExpression(AstObjectCreationExpression expr) {
            AstDeclaration decl = expr.getReferencedElement();
            if (decl instanceof AstMethod) {
                this.createdClasses.add(decl.getDeclaringType());
            }
        }

        public void visitMethodCallExpression(AstMethodCallExpression expr) {
            AstDeclaration decl = expr.getReferencedElement();
            if (decl instanceof AstMethod) {
                this.calledClasses.add(decl.getDeclaringType());
            }
        }

        HashSet getCreatedClasses() {
            return this.createdClasses;
        }

        HashSet getCalledClasses() {
            return this.calledClasses;
        }
    }
}

