/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.visitor.AstExpressionVisitor;
import com.togethersoft.sca.ast.visitor.AstExpressionVisitorAdapter;
import java.util.HashMap;
import java.util.HashSet;

public class TableOfUsedMembers {
    private static HashMap fieldReferences = new HashMap();
    private static HashMap simpleReferences = new HashMap();
    private static HashMap methodReferences = new HashMap();

    public static void reset() {
        fieldReferences = new HashMap();
        simpleReferences = new HashMap();
        methodReferences = new HashMap();
    }

    public static HashSet getFieldReferences(AstDeclaration decl) {
        if (decl == null) {
            return null;
        }
        if (!fieldReferences.containsKey(decl)) {
            TableOfUsedMembers.fillCache(decl);
        }
        return (HashSet)fieldReferences.get(decl);
    }

    public static HashSet getSimpleReferences(AstDeclaration decl) {
        if (decl == null) {
            return null;
        }
        if (!simpleReferences.containsKey(decl)) {
            TableOfUsedMembers.fillCache(decl);
        }
        return (HashSet)simpleReferences.get(decl);
    }

    public static HashSet getMethodReferences(AstDeclaration decl) {
        if (decl == null) {
            return null;
        }
        if (!methodReferences.containsKey(decl)) {
            TableOfUsedMembers.fillCache(decl);
        }
        return (HashSet)methodReferences.get(decl);
    }

    private static void fillCache(AstDeclaration decl) {
        Refs table = new Refs();
        decl.visitExpressions((AstExpressionVisitor)table);
        TableOfUsedMembers.fillReferences(decl, table);
    }

    private static void fillReferences(AstDeclaration decl, Refs table) {
        fieldReferences.put(decl, table.getFieldRefs());
        simpleReferences.put(decl, table.getSimpleRefs());
        methodReferences.put(decl, table.getMethodRefs());
    }

    private static class Refs
    extends AstExpressionVisitorAdapter {
        private HashSet simpleRefs = new HashSet();
        private HashSet fieldRefs = new HashSet();
        private HashSet methodRefs = new HashSet();

        private Refs() {
        }

        HashSet getSimpleRefs() {
            return this.simpleRefs;
        }

        HashSet getFieldRefs() {
            return this.fieldRefs;
        }

        HashSet getMethodRefs() {
            return this.methodRefs;
        }

        public void visitExpression(AstExpression expr) {
            int cop = expr.getObjectKind();
            if (cop == 40 || cop == 36 || cop == 38 || cop == 39 || cop == 29) {
                AstDeclaration decl = ((AstReference)expr).getReferencedElement();
                if (decl instanceof AstField) {
                    if (cop == 40) {
                        this.simpleRefs.add(decl);
                    } else {
                        this.fieldRefs.add(decl);
                    }
                } else if (decl instanceof AstMethod) {
                    this.methodRefs.add(decl);
                }
            }
        }
    }
}

