/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMember;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;
import com.togethersoft.sca.internal.plugin.metric.impl.TRAp;
import com.togethersoft.sca.internal.plugin.metric.impl.Util;
import java.util.HashSet;
import java.util.Iterator;

public class TRDu
extends ClassMetric {
    protected void measure(AstType type, MetricResult result) {
        double sumRDD = 0.0;
        HashSet subtypes = new HashSet();
        Util.computeSubtypeClosure(subtypes, type);
        AstField[] fields = type.getFields();
        sumRDD += this.countRDD((AstMember[])fields, subtypes);
        AstMethod[] methods = type.getExecutableFragments();
        sumRDD += this.countRDD((AstMember[])methods, subtypes);
        int numMembers = this.numUsableMembers(fields, methods);
        if (numMembers > 0) {
            result.setValue((int)(100.0 * sumRDD / (double)numMembers + 0.5));
        } else {
            result.setValue(0);
        }
    }

    private double countRDD(AstMember[] members, HashSet types) {
        double rdd = 0.0;
        int i = 0;
        while (i < members.length) {
            Iterator iter = types.iterator();
            while (iter.hasNext()) {
                AstType d = (AstType)iter.next();
                if (d.isBinary()) continue;
                rdd += this.RDD(members[i], d);
            }
            ++i;
        }
        return rdd;
    }

    protected double RDD(AstMember member, AstType d) {
        AstMethod[] methods = d.getExecutableFragments();
        int i = 0;
        while (i < methods.length) {
            HashSet usedSet;
            if (!methods[i].isInitializer() && (usedSet = TRAp.usedMembers(methods[i])).contains(member)) {
                return 1.0;
            }
            ++i;
        }
        return 0.0;
    }

    private int numUsableMembers(AstField[] fields, AstMethod[] methods) {
        int numMembers = 0;
        int i = 0;
        while (i < fields.length) {
            if (!fields[i].isPrivate()) {
                ++numMembers;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < methods.length) {
            if (!methods[i2].isPrivate() && !methods[i2].isInitializer()) {
                ++numMembers;
            }
            ++i2;
        }
        return numMembers;
    }
}

