/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;
import com.togethersoft.sca.internal.plugin.metric.impl.TableOfUsedMembers;
import java.util.HashSet;

public class TRAp
extends ClassMetric {
    private double kf;
    protected double sumRDA;
    protected int numMethods;

    protected void measure(AstType type, MetricResult result) {
        this.sumRDA = 0.0;
        this.numMethods = 0;
        AstMethod[] methods = type.getExecutableFragments();
        int i = 0;
        while (i < methods.length) {
            if (!methods[i].isInitializer()) {
                ++this.numMethods;
                AstType ancestor = type.getSuperClass();
                while (ancestor != null) {
                    if (ancestor.isSource()) {
                        this.sumRDA += this.RDA(methods[i], ancestor);
                    }
                    ancestor = ancestor.getSuperClass();
                }
            }
            ++i;
        }
        if (this.numMethods > 0) {
            result.setValue((int)(100.0 * this.sumRDA / (double)this.numMethods + 0.5));
        } else {
            result.setValue(0);
        }
    }

    protected double RDA(AstMethod method, AstType ancestor) {
        double total = 0.0;
        double count = 0.0;
        HashSet usedSet = TRAp.usedMembers(method);
        AstField[] fields = ancestor.getFields();
        int i = 0;
        while (i < fields.length) {
            if (usedSet.contains(fields[i])) {
                count += 1.0;
            }
            total += 1.0;
            ++i;
        }
        AstMethod[] methods = ancestor.getExecutableFragments();
        int i2 = 0;
        while (i2 < methods.length) {
            if (!methods[i2].isInitializer()) {
                boolean isAbstract = methods[i2].isAbstract();
                if (usedSet.contains(methods[i2])) {
                    count = isAbstract ? (count += this.kf) : (count += 1.0);
                }
                total = isAbstract ? (total += this.kf) : (total += 1.0);
            }
            ++i2;
        }
        return total > 0.0 ? count / total : 0.0;
    }

    public static HashSet usedMembers(AstMethod method) {
        HashSet resultSet = new HashSet();
        resultSet.addAll(TableOfUsedMembers.getFieldReferences((AstDeclaration)method));
        resultSet.addAll(TableOfUsedMembers.getSimpleReferences((AstDeclaration)method));
        resultSet.addAll(TableOfUsedMembers.getMethodReferences((AstDeclaration)method));
        return resultSet;
    }

    public void setDescriptor(IAnalyzerDescriptor descriptor) {
        super.setDescriptor(descriptor);
        this.kf = (100.0 - (double)descriptor.getParameterRegistry().getIntegerValue("Stability factor", 50L)) / 100.0;
    }
}

