/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassVisitor;
import com.togethersoft.sca.internal.plugin.metric.impl.Util;
import java.util.HashSet;
import java.util.Iterator;

public class PF
extends ClassVisitor {
    private int numOverriden;
    private int maxOverriden;

    protected void measure(AstModel model, MetricResult result) {
        this.numOverriden = 0;
        this.maxOverriden = 0;
        super.measure(model, result);
        if (this.maxOverriden > 0) {
            result.setValue(this.numOverriden, this.maxOverriden);
        } else {
            result.setValue(0);
        }
    }

    protected void measureType(AstType type) {
        super.measureType(type);
        if (type.isInterface()) {
            return;
        }
        HashSet set = null;
        int numSubtypes = -1;
        int numLocal = -1;
        AstMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (!methods[i].isPrivate()) {
                if (this.isOverriden(methods[i])) {
                    if (!methods[i].isStatic()) {
                        ++this.numOverriden;
                    }
                } else {
                    if (numSubtypes < 0) {
                        set = new HashSet();
                        Util.computeSubtypeClosure(set, type);
                        numSubtypes = set.size();
                    }
                    if (methods[i].isPackage()) {
                        if (numLocal < 0) {
                            numLocal = 0;
                            AstPackage pkg = type.getPackage();
                            Iterator iter = set.iterator();
                            while (iter.hasNext()) {
                                AstType t = (AstType)iter.next();
                                if (t.getPackage() != pkg) continue;
                                ++numLocal;
                            }
                        }
                    } else {
                        this.maxOverriden += numSubtypes;
                    }
                }
            }
            ++i;
        }
    }

    private boolean isOverriden(AstMethod method) {
        AstMethod[] ovr = method.getOverridden();
        int i = 0;
        while (i < ovr.length) {
            AstType type = ovr[i].getDeclaringType();
            if (!type.isInterface() && type.isSource()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

