/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.PackageMetric;
import com.togethersoft.sca.internal.plugin.metric.impl.Pair;
import java.util.HashSet;

public class PC
extends PackageMetric {
    protected void measure(AstPackage pack, MetricResult result) {
        HashSet<Pair> setOfDependency = new HashSet<Pair>();
        int numOfClasses = 0;
        AstCompilationUnit[] units = pack.getCompilationUnits();
        int i = 0;
        while (i < units.length) {
            AstType[] types = units[i].getTypes();
            numOfClasses += types.length;
            int j = 0;
            while (j < types.length) {
                AstType[] classes = types[j].getImportCouplings();
                int n = 0;
                while (n < classes.length) {
                    if (classes[n].getPackage() == pack) {
                        setOfDependency.add(new Pair(types[j].getElementName(), classes[n].getElementName()));
                    }
                    ++n;
                }
                ++j;
            }
            ++i;
        }
        int numOfDependPairs = setOfDependency.size();
        int numAllPairs = numOfClasses * (numOfClasses - 1) / 2;
        result.setValue(numOfDependPairs, numAllPairs);
    }
}

