/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstBinaryExpression;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstDeclarationStatement;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstUnaryExpression;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.ast.visitor.AstExpressionVisitor;
import com.togethersoft.sca.ast.visitor.AstExpressionVisitorAdapter;
import com.togethersoft.sca.ast.visitor.AstStatementVisitor;
import com.togethersoft.sca.ast.visitor.AstStatementVisitorAdapter;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;
import java.util.HashSet;

public class NUOPRTR
extends ClassMetric {
    private HashSet set = new HashSet();
    protected int numOperators;

    protected void measure(AstType type, MetricResult result) {
        result.setValue(this.measureNUOPRTR(type));
    }

    public int measureNUOPRTR(AstType type) {
        this.numOperators = 0;
        this.set.clear();
        AstMethod[] methods = type.getExecutableFragments();
        int i = 0;
        while (i < methods.length) {
            this.countOperands(methods[i].getBody());
            ++i;
        }
        return this.set.size();
    }

    private void countOperands(AstCompoundStatement body) {
        if (body == null) {
            return;
        }
        body.visitStatements((AstStatementVisitor)new AstStatementVisitorAdapter(){

            public void visitStatement(AstStatement stmt) {
                int cop = stmt.getObjectKind();
                if (cop == 17 || cop == 10 || cop == 27) {
                    ++NUOPRTR.this.numOperators;
                    NUOPRTR.this.addOperator(17, 0);
                } else if (cop == 14 || cop == 16 || cop == 13 || cop == 15) {
                    ++NUOPRTR.this.numOperators;
                    NUOPRTR.this.addOperator(cop, 0);
                }
            }

            public void visitDeclarationStatement(AstDeclarationStatement stmt) {
                AstDeclaration[] decls = stmt.getDeclarations();
                int i = 0;
                while (i < decls.length) {
                    if (decls[i].getObjectKind() == 9 && ((AstVariable)decls[i]).getInitializer() != null) {
                        ++NUOPRTR.this.numOperators;
                        NUOPRTR.this.addOperator(32, 0);
                    }
                    ++i;
                }
            }
        });
        body.visitExpressions((AstExpressionVisitor)new AstExpressionVisitorAdapter(){

            public void visitExpression(AstExpression expr) {
                int cop = expr.getObjectKind();
                if (cop == 39) {
                    NUOPRTR.this.numOperators += 2;
                    NUOPRTR.this.addOperator(cop, 0);
                    NUOPRTR.this.addOperator(38, 0);
                } else if (cop == 29) {
                    ++NUOPRTR.this.numOperators;
                    NUOPRTR.this.addOperator(38, 0);
                } else if (cop != 40 && cop != 37 && cop != 45 && cop != 42 && cop != 41 && cop != 46 && cop != 44) {
                    ++NUOPRTR.this.numOperators;
                    if (cop == 33) {
                        NUOPRTR.this.addOperator(cop, ((AstBinaryExpression)expr).getExpressionKind());
                    } else if (cop == 43) {
                        NUOPRTR.this.addOperator(cop, ((AstUnaryExpression)expr).getExpressionKind());
                    } else if (cop == 32) {
                        NUOPRTR.this.addOperator(cop, ((AstAssignmentExpression)expr).getExpressionKind());
                    } else {
                        NUOPRTR.this.addOperator(cop, 0);
                    }
                }
            }
        });
    }

    private void addOperator(int kind, int cop) {
        this.set.add(new Integer(kind * 100 + cop));
    }
}

