/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstConstructorInvocation;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstLiteral;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstMethodCallExpression;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.AstSuperExpression;
import com.togethersoft.sca.ast.AstThisExpression;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeExpression;
import com.togethersoft.sca.ast.visitor.AstExpressionVisitor;
import com.togethersoft.sca.ast.visitor.AstExpressionVisitorAdapter;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;
import java.util.HashSet;

public class NUOPRND
extends ClassMetric {
    private HashSet set = new HashSet();
    protected int numOperands;

    protected void measure(AstType type, MetricResult result) {
        result.setValue(this.measureNUOPRND(type));
    }

    public int measureNUOPRND(AstType type) {
        this.numOperands = 0;
        this.set.clear();
        AstMethod[] methods = type.getExecutableFragments();
        int i = 0;
        while (i < methods.length) {
            this.countOperands(methods[i].getBody());
            ++i;
        }
        return this.set.size();
    }

    private void countOperands(AstCompoundStatement body) {
        if (body == null) {
            return;
        }
        body.visitExpressions((AstExpressionVisitor)new AstExpressionVisitorAdapter(){

            public void visitExpression(AstExpression expr) {
                AstDeclaration decl;
                if (expr.getParent().getObjectKind() == 19) {
                    return;
                }
                if (expr instanceof AstReference && (decl = ((AstReference)expr).getReferencedElement()) != null) {
                    if (decl.getObjectKind() == 6 && ((AstMethod)decl).isConstructor()) {
                        decl = decl.getDeclaringType();
                    }
                    NUOPRND.this.addOperand(decl);
                }
            }

            public void visitConstructorInvocation(AstConstructorInvocation expr) {
            }

            public void visitMethodCallExpression(AstMethodCallExpression expr) {
            }

            public void visitSuperExpression(AstSuperExpression expr) {
            }

            public void visitThisExpression(AstThisExpression expr) {
                if (expr.getParent().getObjectKind() == 19) {
                    return;
                }
                NUOPRND.this.addOperand(expr.getReferencedElement());
            }

            public void visitTypeExpression(AstTypeExpression expr) {
            }

            public void visitLiteral(AstLiteral expr) {
                if (expr.getParent().getObjectKind() == 19) {
                    return;
                }
                NUOPRND.this.addOperand(expr.getText());
            }
        });
    }

    private void addOperand(Object operand) {
        ++this.numOperands;
        if (operand != null) {
            this.set.add(operand);
        }
    }
}

