/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstMember;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.MemberMetric;

public class NOM
extends MemberMetric {
    private boolean countAncestors;
    private boolean countConstructors;
    private boolean countConstants;

    protected void measure(AstType type, MetricResult result) {
        int total;
        if (this.countAncestors) {
            total = this.measure((AstMember[])type.getAllFields());
            total += this.measure((AstMember[])type.getAllMethods());
        } else {
            total = this.measure((AstMember[])type.getFields());
            total += this.measure((AstMember[])type.getMethods());
        }
        if (this.countConstructors) {
            total += this.measure((AstMember[])type.getConstructors());
        }
        result.setValue(total);
    }

    private int measure(AstMember[] members) {
        int count = 0;
        int i = 0;
        while (i < members.length) {
            AstMember m = members[i];
            if ((!m.isStatic() || !m.isFinal() || this.countConstants) && this.isEligible(m)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void setDescriptor(IAnalyzerDescriptor descriptor) {
        super.setDescriptor(descriptor);
        this.countAncestors = descriptor.getParameterRegistry().getBooleanValue("Include ancestors", false);
        this.countConstructors = descriptor.getParameterRegistry().getBooleanValue("Include constructors", false);
        this.countConstants = descriptor.getParameterRegistry().getBooleanValue("Include constants", false);
    }
}

