/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstDeclarationStatement;
import com.togethersoft.sca.ast.AstForStatement;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.ast.visitor.AstStatementVisitor;
import com.togethersoft.sca.ast.visitor.AstStatementVisitorAdapter;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.MethodMetric;

public class NOLV
extends MethodMetric {
    protected void measure(AstMethod method, MetricResult result) {
        VariableCounter counter = new VariableCounter();
        AstCompoundStatement body = method.getBody();
        if (body != null) {
            body.visitStatements((AstStatementVisitor)counter);
        }
        result.setValue(counter.numVariables());
    }

    private static class VariableCounter
    extends AstStatementVisitorAdapter {
        private int nVariables;

        private VariableCounter() {
        }

        int numVariables() {
            return this.nVariables;
        }

        public void visitCompoundStatement(AstCompoundStatement stmt) {
            AstVariable[] locals = stmt.getLocalVariables();
            int i = 0;
            while (i < locals.length) {
                if (locals[i].getParent().getObjectKind() != 6) {
                    ++this.nVariables;
                }
                ++i;
            }
        }

        public void visitForStatement(AstForStatement stmt) {
            AstStatement[] inits = stmt.getInitializers();
            if (inits.length == 1 && inits[0].getObjectKind() == 24) {
                AstDeclaration[] decls = ((AstDeclarationStatement)inits[0]).getDeclarations();
                this.nVariables += decls.length;
            }
        }
    }
}

